/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.msl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.database.AbstractDatabaseImportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorMSL;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.MSLReader;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSLDatabaseImportConverter
extends AbstractDatabaseImportConverter {
    private static final Logger logger = Logger.getLogger(MSLDatabaseImportConverter.class);
    private static final String DESCRIPTION = "AMDIS MSL MassSpectrum Import";

    public IProcessingInfo<IMassSpectra> convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            try {
                file = SpecificationValidatorMSL.validateSpecification(file);
                MSLReader massSpectraReader = new MSLReader();
                IMassSpectra massSpectra = massSpectraReader.read(file, monitor);
                if (massSpectra != null && massSpectra.size() > 0) {
                    processingInfo.setProcessingResult((Object)massSpectra);
                } else {
                    processingInfo.addErrorMessage(DESCRIPTION, "No mass spectra are stored." + file.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotReadableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not readable: " + file.getAbsolutePath());
            }
            catch (FileIsEmptyException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is empty: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

