/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.msl;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramExportConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorMSL;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.chromatogram.ChromatogramWriterMSL;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramPeakExportConverter
extends AbstractChromatogramExportConverter
implements IChromatogramExportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramPeakExportConverter.class);
    private static final String DESCRIPTION = "NIST MSL Chromatogram Peak Export Converter";

    public IProcessingInfo convert(File file, IChromatogram<? extends IPeak> chromatogram, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file = SpecificationValidatorMSL.validateSpecification(file));
        if (!processingInfo.hasErrorMessages() && chromatogram instanceof IChromatogramMSD) {
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            ChromatogramWriterMSL writer = new ChromatogramWriterMSL();
            try {
                writer.writeChromatogram(file, chromatogramMSD, monitor);
                processingInfo.setProcessingResult((Object)file);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

