/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter;

import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleQuantExportCSV {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void write(File file, ISampleQuantReport sampleQuantReport, IProgressMonitor monitor) throws Exception {
        try (CSVPrinter csvFilePrinter = null;){
            FileWriter fileWriter = new FileWriter(file);
            csvFilePrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.TDF);
            csvFilePrinter.printRecord(new Object[]{"Name", sampleQuantReport.getName()});
            csvFilePrinter.printRecord(new Object[]{"Data Name", sampleQuantReport.getDataName()});
            csvFilePrinter.printRecord(new Object[]{"Date", sampleQuantReport.getDate()});
            csvFilePrinter.printRecord(new Object[]{"Operator", sampleQuantReport.getOperator()});
            csvFilePrinter.printRecord(new Object[]{"Misc Info", sampleQuantReport.getMiscInfo()});
            csvFilePrinter.printRecord(new Object[]{""});
            csvFilePrinter.printRecord(new Object[]{"ID", "CAS#", "Name", "Max Scan", "Concentration", "Unit", "Misc", "Type", "Min Match Quality", "Match Quality", "Validated"});
            for (ISampleQuantSubstance sampleQuantSubstance : sampleQuantReport.getSampleQuantSubstances()) {
                String id = Integer.toString(sampleQuantSubstance.getId());
                String casNumber = sampleQuantSubstance.getCasNumber();
                String name = sampleQuantSubstance.getName();
                String maxScan = Integer.toString(sampleQuantSubstance.getMaxScan());
                String concentration = this.decimalFormat.format(sampleQuantSubstance.getConcentration());
                String unit = sampleQuantSubstance.getUnit();
                String misc = sampleQuantSubstance.getMisc();
                String type = sampleQuantSubstance.getType();
                String minMatchQuality = this.decimalFormat.format(sampleQuantSubstance.getMinMatchQuality());
                String matchQuality = this.decimalFormat.format(sampleQuantSubstance.getMatchQuality());
                String validated = Boolean.toString(sampleQuantSubstance.isValidated());
                csvFilePrinter.printRecord(new Object[]{id, casNumber, name, maxScan, concentration, unit, misc, type, minMatchQuality, matchQuality, validated});
            }
        }
    }
}

