/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.chemclipse.ux.extension.ui.swt.TaskTile;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TaskTileContainer {
    public static final Color DEFAULT_COLOR_TEXT = Colors.WHITE;
    public static final Color DEFAULT_COLOR_INACTIVE = Colors.getColor((int)74, (int)142, (int)142);
    public static final Color DEFAULT_COLOR_ACTIVE = Colors.getColor((int)5, (int)100, (int)100);
    private final List<TaskTile> tiles = new ArrayList<TaskTile>();
    private final Composite container;
    private final Supplier<IEclipseContext> contextSupplier;
    private final MouseMoveListener tileMouseMoveListener = mouseMove -> {
        for (TaskTile tile : this.tiles) {
            if (tile == mouseMove.widget) {
                tile.setActive();
                continue;
            }
            tile.setInactive();
        }
    };
    private final Color[] colors;

    public TaskTileContainer(Composite parent, int columns, Supplier<IEclipseContext> contextSupplier) {
        this(parent, columns, contextSupplier, new Color[]{DEFAULT_COLOR_ACTIVE, DEFAULT_COLOR_INACTIVE, DEFAULT_COLOR_TEXT});
    }

    public TaskTileContainer(Composite parent, int columns, Supplier<IEclipseContext> contextSupplier, Color[] colors) {
        this.contextSupplier = contextSupplier;
        this.colors = colors;
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(columns, true));
        this.container.setBackgroundMode(2);
        MouseTrackAdapter trackAdapter = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent me) {
                for (TaskTile tile : TaskTileContainer.this.tiles) {
                    tile.setInactive();
                }
            }
        };
        this.container.addMouseTrackListener((MouseTrackListener)trackAdapter);
        parent.addMouseTrackListener((MouseTrackListener)trackAdapter);
    }

    public TaskTile addTaskTile(TileDefinition definition) {
        GridData gridData = new GridData(1808);
        TaskTile taskTile = new TaskTile(this.container, definition, this::executeHandler, this::computeStyle, this.colors);
        taskTile.setLayoutData(gridData);
        taskTile.addMouseMoveListener(this.tileMouseMoveListener);
        this.tiles.add(taskTile);
        this.container.layout();
        return taskTile;
    }

    private void executeHandler(TileDefinition tileDefinition) {
        ContextInjectionFactory.invoke((Object)tileDefinition, Execute.class, (IEclipseContext)this.contextSupplier.get(), null);
    }

    protected int computeStyle(TileDefinition tileDefinition) {
        boolean largeText = tileDefinition.getIcon() == null && tileDefinition.getTitle().length() == 1;
        int style = 0;
        if (this.canExecute(tileDefinition)) {
            style |= 4;
        }
        if (largeText) {
            style |= 2;
        }
        return style;
    }

    private boolean canExecute(TileDefinition tileDefinition) {
        Object invoke = ContextInjectionFactory.invoke((Object)tileDefinition, CanExecute.class, (IEclipseContext)this.contextSupplier.get(), (Object)Boolean.TRUE);
        if (invoke instanceof Boolean) {
            return (Boolean)invoke;
        }
        return true;
    }

    public void update() {
        for (TaskTile taskTile : this.tiles) {
            taskTile.updateFromDefinition();
        }
    }

    public void removeTaskTile(TaskTile tile) {
        tile.removeMouseMoveListener(this.tileMouseMoveListener);
        this.tiles.remove((Object)tile);
        tile.dispose();
        this.container.layout();
    }

    public List<TaskTile> getTiles() {
        return Collections.unmodifiableList(this.tiles);
    }
}

