/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.Activator;
import org.eclipse.chemclipse.ux.extension.ui.provider.LazyFileExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.swt.DataExplorerTreeUI;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifierCache;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class MultiDataExplorerTreeUI {
    private static final DataExplorerTreeUI.DataExplorerTreeRoot[] DEFAULT_ROOTS = new DataExplorerTreeUI.DataExplorerTreeRoot[]{DataExplorerTreeUI.DataExplorerTreeRoot.DRIVES, DataExplorerTreeUI.DataExplorerTreeRoot.HOME, DataExplorerTreeUI.DataExplorerTreeRoot.USER_LOCATION};
    private static final String TAB_KEY_SUFFIX = "selectedTab";
    private final TabFolder tabFolder;
    private final DataExplorerTreeUI[] treeUIs;
    private final IPreferenceStore preferenceStore;
    private final SupplierFileIdentifierCache identifierCache;

    public MultiDataExplorerTreeUI(Composite parent, IPreferenceStore preferenceStore) {
        this(parent, new SupplierFileIdentifierCache(LazyFileExplorerContentProvider.MAX_CACHE_SIZE), preferenceStore);
    }

    public MultiDataExplorerTreeUI(Composite parent, SupplierFileIdentifierCache identifierCache, IPreferenceStore preferenceStore) {
        this(parent, identifierCache, DEFAULT_ROOTS, preferenceStore);
    }

    public MultiDataExplorerTreeUI(Composite parent, SupplierFileIdentifierCache identifierCache, DataExplorerTreeUI.DataExplorerTreeRoot[] roots, IPreferenceStore preferenceStore) {
        this.identifierCache = identifierCache;
        this.preferenceStore = preferenceStore;
        this.tabFolder = new TabFolder(parent, 0);
        this.treeUIs = new DataExplorerTreeUI[roots.length];
        int i = 0;
        while (i < roots.length) {
            this.treeUIs[i] = this.createTab(this.tabFolder, roots[i]);
            ++i;
        }
    }

    protected Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> getIdentifierSupplier() {
        return this.identifierCache;
    }

    public void setSupplierFileIdentifier(Collection<? extends ISupplierFileIdentifier> supplierFileEditorSupportList) {
        this.identifierCache.setIdentifier(supplierFileEditorSupportList);
        DataExplorerTreeUI[] dataExplorerTreeUIArray = this.treeUIs;
        int n = this.treeUIs.length;
        int n2 = 0;
        while (n2 < n) {
            DataExplorerTreeUI ui = dataExplorerTreeUIArray[n2];
            ui.getTreeViewer().refresh();
            ++n2;
        }
    }

    public void expandLastDirectoryPath() {
        DataExplorerTreeUI[] dataExplorerTreeUIArray = this.treeUIs;
        int n = this.treeUIs.length;
        int n2 = 0;
        while (n2 < n) {
            DataExplorerTreeUI ui = dataExplorerTreeUIArray[n2];
            String preferenceKey = this.getPreferenceKey(ui.getRoot());
            ui.expandLastDirectoryPath(this.preferenceStore, preferenceKey);
            ++n2;
        }
        int index = this.preferenceStore.getInt(this.getSelectedTabPreferenceKey());
        this.tabFolder.setSelection(index);
    }

    public void saveLastDirectoryPath() {
        DataExplorerTreeUI[] dataExplorerTreeUIArray = this.treeUIs;
        int n = this.treeUIs.length;
        int n2 = 0;
        while (n2 < n) {
            DataExplorerTreeUI ui = dataExplorerTreeUIArray[n2];
            ui.saveLastDirectoryPath(this.preferenceStore, this.getPreferenceKey(ui.getRoot()));
            ++n2;
        }
        int index = this.tabFolder.getSelectionIndex();
        this.preferenceStore.setValue(this.getSelectedTabPreferenceKey(), index);
        if (this.preferenceStore.needsSaving() && this.preferenceStore instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Storing preferences failed", (Throwable)e));
            }
        }
    }

    protected String getSelectedTabPreferenceKey() {
        return String.valueOf(this.getPreferenceKey(DataExplorerTreeUI.DataExplorerTreeRoot.USER_LOCATION)) + TAB_KEY_SUFFIX;
    }

    protected String getUserLocationPreferenceKey() {
        return "userLocation";
    }

    protected String getPreferenceKey(DataExplorerTreeUI.DataExplorerTreeRoot root) {
        return DataExplorerTreeUI.getDefaultPathPreferenceKey(root);
    }

    private DataExplorerTreeUI createTab(final TabFolder tabFolder, DataExplorerTreeUI.DataExplorerTreeRoot root) {
        final TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(root.toString());
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        final DataExplorerTreeUI treeUI = new DataExplorerTreeUI(composite, root, this.getIdentifierSupplier());
        final TreeViewer treeViewer = treeUI.getTreeViewer();
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] array = treeViewer.getStructuredSelection().toArray();
                File[] files = new File[array.length];
                int i = 0;
                while (i < files.length) {
                    files[i] = (File)array[i];
                    ++i;
                }
                MultiDataExplorerTreeUI.this.handleSelection(files, treeUI);
            }
        };
        treeViewer.addSelectionChangedListener(selectionChangedListener);
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
                MultiDataExplorerTreeUI.this.handleDoubleClick(file, treeUI);
            }
        });
        this.initTabComponent(composite, treeUI);
        tab.setControl((Control)composite);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabItem[] selection;
                TabItem[] tabItemArray = selection = tabFolder.getSelection();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    if (item == tab) {
                        selectionChangedListener.selectionChanged(null);
                    }
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return treeUI;
    }

    protected void initTabComponent(Composite parent, DataExplorerTreeUI treeUI) {
        if (treeUI.getRoot() == DataExplorerTreeUI.DataExplorerTreeRoot.USER_LOCATION) {
            this.addUserLocationButton(parent, treeUI);
            File directory = new File(this.preferenceStore.getString(this.getUserLocationPreferenceKey()));
            if (directory.exists()) {
                treeUI.getTreeViewer().setInput((Object)new File[]{directory});
            }
        }
    }

    private void addUserLocationButton(Composite parent, final DataExplorerTreeUI treeUI) {
        Button button = new Button(parent, 8);
        button.setText("Select User Location");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/folder_opened.gif", "16x16"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File directory;
                DirectoryDialog directoryDialog = new DirectoryDialog(e.display.getActiveShell(), 8);
                directoryDialog.setText("Select a directory.");
                String pathname = directoryDialog.open();
                if (pathname != null && (directory = new File(pathname)).exists()) {
                    MultiDataExplorerTreeUI.this.preferenceStore.setValue(MultiDataExplorerTreeUI.this.getUserLocationPreferenceKey(), directory.getAbsolutePath());
                    treeUI.getTreeViewer().setInput((Object)new File[]{directory});
                }
            }
        });
    }

    protected void handleDoubleClick(File file, DataExplorerTreeUI treeUI) {
    }

    protected void handleSelection(File[] files, DataExplorerTreeUI treeUI) {
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        TabItem[] tabItemArray = this.tabFolder.getSelection();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            item.getControl().setFocus();
            ++n2;
        }
    }

    public Control getControl() {
        return this.tabFolder;
    }
}

