/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.ux.extension.ui.Activator;
import org.eclipse.chemclipse.ux.extension.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.ui.provider.DataExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.DataExplorerLabelProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.LazyFileExplorerContentProvider;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifierCache;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DataExplorerTreeUI {
    private final TreeViewer treeViewer;
    private final DataExplorerTreeRoot root;

    public DataExplorerTreeUI(Composite parent, DataExplorerTreeRoot root) {
        this(parent, root, Collections.emptyList());
    }

    public DataExplorerTreeUI(Composite parent, DataExplorerTreeRoot root, Collection<? extends ISupplierFileIdentifier> identifier) {
        this(parent, root, (Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>>)DataExplorerTreeUI.createIdentifierCache(identifier));
    }

    private static SupplierFileIdentifierCache createIdentifierCache(Collection<? extends ISupplierFileIdentifier> identifier) {
        SupplierFileIdentifierCache cache = new SupplierFileIdentifierCache(LazyFileExplorerContentProvider.MAX_CACHE_SIZE);
        cache.setIdentifier(identifier);
        return cache;
    }

    public DataExplorerTreeUI(Composite parent, DataExplorerTreeRoot root, Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> identifier) {
        this.root = root;
        this.treeViewer = new TreeViewer(parent, 0x10000002);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setExpandPreCheckFilters(true);
        this.treeViewer.setContentProvider((IContentProvider)new DataExplorerContentProvider(identifier));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DataExplorerLabelProvider(identifier));
        switch (root) {
            case DRIVES: {
                this.treeViewer.setInput((Object)File.listRoots());
                break;
            }
            case HOME: {
                this.treeViewer.setInput((Object)new File[]{new File(UserManagement.getUserHome())});
                break;
            }
            case USER_LOCATION: {
                this.treeViewer.setInput((Object)new File[]{this.getUserLocation()});
                break;
            }
        }
    }

    public DataExplorerTreeRoot getRoot() {
        return this.root;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private File getUserLocation() {
        String userLocationPath = PreferenceSupplier.getUserLocationPath();
        File userLocation = new File(userLocationPath);
        if (!userLocation.exists()) {
            userLocation = new File(UserManagement.getUserHome());
        }
        return userLocation;
    }

    public void expandLastDirectoryPath(IPreferenceStore preferenceStore) {
        this.expandLastDirectoryPath(preferenceStore, DataExplorerTreeUI.getDefaultPathPreferenceKey(this.root));
    }

    public void expandLastDirectoryPath(IPreferenceStore preferenceStore, String preferenceKey) {
        File lastFile = new File(preferenceStore.getString(preferenceKey));
        if (lastFile.exists()) {
            this.treeViewer.expandToLevel((Object)lastFile, 1);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)lastFile), true);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerTreeUI.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            });
        }
    }

    public void saveLastDirectoryPath(IPreferenceStore preferenceStore) {
        this.saveLastDirectoryPath(preferenceStore, DataExplorerTreeUI.getDefaultPathPreferenceKey(this.getRoot()));
    }

    public void saveLastDirectoryPath(IPreferenceStore preferenceStore, String preferenceKey) {
        File file = (File)this.treeViewer.getStructuredSelection().getFirstElement();
        if (file != null) {
            File directoryPath = null;
            if (file.isFile()) {
                File directory = file.getParentFile();
                if (directory != null) {
                    File directoryRoot = directory.getParentFile();
                    directoryPath = this.getNumberOfChildDirectories(directoryRoot) <= 1 ? directoryRoot : directory;
                }
            } else {
                directoryPath = file;
            }
            if (directoryPath != null) {
                preferenceStore.setValue(preferenceKey, directoryPath.getAbsolutePath());
            }
        }
        if (preferenceStore.needsSaving() && preferenceStore instanceof IPersistentPreferenceStore) {
            try {
                IPersistentPreferenceStore persistentPreferenceStore = (IPersistentPreferenceStore)preferenceStore;
                persistentPreferenceStore.save();
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Storing preferences failed", (Throwable)e));
            }
        }
    }

    public static final String getDefaultPathPreferenceKey(DataExplorerTreeRoot root) {
        switch (root) {
            case DRIVES: {
                return "selectedDrivePath";
            }
            case HOME: {
                return "selectedHomePath";
            }
            case USER_LOCATION: {
                return "selectedUserLocationPath";
            }
        }
        return "selected" + root.name() + "path";
    }

    private int getNumberOfChildDirectories(File directory) {
        int counter = 0;
        if (directory != null) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ++counter;
                }
                ++n2;
            }
        }
        return counter;
    }

    public static enum DataExplorerTreeRoot {
        NONE(""),
        DRIVES("Drives"),
        HOME("Home"),
        USER_LOCATION("User Location");

        private String label;

        private DataExplorerTreeRoot(String label) {
            this.label = label;
        }

        public String toString() {
            return this != NONE ? this.label : super.toString();
        }
    }
}

