/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.meannormalizer.core;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.meannormalizer.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.meannormalizer.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.meannormalizer.settings.FilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.CalculationException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.exceptions.NoTotalSignalStoredException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof FilterSettings) {
            try {
                this.applyMeanNormalizerFilter(chromatogramSelection);
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection was successfully normalized."));
            }
            catch (FilterException e) {
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage()));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        FilterSettings filterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void applyMeanNormalizerFilter(IChromatogramSelection chromatogramSelection) throws FilterException {
        ITotalScanSignals totalScanSignals;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        try {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            totalScanSignals = totalScanSignalExtractor.getTotalScanSignals(startScan, stopScan);
            TotalScanSignalsModifier.meanNormalize((ITotalScanSignals)totalScanSignals);
        }
        catch (NoTotalSignalStoredException e) {
            throw new FilterException("There were no total ion signals stored.");
        }
        catch (CalculationException e) {
            throw new FilterException(e.getMessage());
        }
        catch (ChromatogramIsNullException e) {
            throw new FilterException("The chromatogram must be not null.");
        }
        int scan = startScan;
        while (scan <= stopScan) {
            IScan scanRecord = chromatogram.getScan(scan);
            float normalizedAbundance = totalScanSignals.getTotalScanSignal(scan).getTotalSignal();
            if (normalizedAbundance <= 0.0f) {
                normalizedAbundance = 0.1f;
            }
            scanRecord.adjustTotalSignal(normalizedAbundance);
            ++scan;
        }
    }
}

