/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeSource;

public final class FieldInvertState {
    final int indexCreatedVersionMajor;
    final String name;
    int position;
    int length;
    int numOverlap;
    int offset;
    int maxTermFrequency;
    int uniqueTermCount;
    int lastStartOffset = 0;
    int lastPosition = 0;
    AttributeSource attributeSource;
    OffsetAttribute offsetAttribute;
    PositionIncrementAttribute posIncrAttribute;
    PayloadAttribute payloadAttribute;
    TermToBytesRefAttribute termAttribute;
    TermFrequencyAttribute termFreqAttribute;

    public FieldInvertState(int indexCreatedVersionMajor, String name) {
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.name = name;
    }

    public FieldInvertState(int indexCreatedVersionMajor, String name, int position, int length, int numOverlap, int offset) {
        this(indexCreatedVersionMajor, name);
        this.position = position;
        this.length = length;
        this.numOverlap = numOverlap;
        this.offset = offset;
    }

    void reset() {
        this.position = -1;
        this.length = 0;
        this.numOverlap = 0;
        this.offset = 0;
        this.maxTermFrequency = 0;
        this.uniqueTermCount = 0;
        this.lastStartOffset = 0;
        this.lastPosition = 0;
    }

    void setAttributeSource(AttributeSource attributeSource) {
        if (this.attributeSource != attributeSource) {
            this.attributeSource = attributeSource;
            this.termAttribute = attributeSource.getAttribute(TermToBytesRefAttribute.class);
            this.termFreqAttribute = attributeSource.addAttribute(TermFrequencyAttribute.class);
            this.posIncrAttribute = attributeSource.addAttribute(PositionIncrementAttribute.class);
            this.offsetAttribute = attributeSource.addAttribute(OffsetAttribute.class);
            this.payloadAttribute = attributeSource.getAttribute(PayloadAttribute.class);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getNumOverlap() {
        return this.numOverlap;
    }

    public void setNumOverlap(int numOverlap) {
        this.numOverlap = numOverlap;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMaxTermFrequency() {
        return this.maxTermFrequency;
    }

    public int getUniqueTermCount() {
        return this.uniqueTermCount;
    }

    public AttributeSource getAttributeSource() {
        return this.attributeSource;
    }

    public String getName() {
        return this.name;
    }

    public int getIndexCreatedVersionMajor() {
        return this.indexCreatedVersionMajor;
    }
}

