/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.workbench;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DisplayUtils {
    private static ExecutorService BACKGROUND_EXECUTOR = Executors.newCachedThreadPool();
    private static final Logger logger = Logger.getLogger(DisplayUtils.class);
    public static final UISynchronize DEFAULT_DISPLAY = new UISynchronize(){

        public void syncExec(Runnable runnable) {
            Display.getDefault().syncExec(runnable);
        }

        public void asyncExec(Runnable runnable) {
            Display.getDefault().asyncExec(runnable);
        }
    };

    public static Display getDisplay(Widget widget) {
        Display display = null;
        display = widget instanceof Control ? ((Control)widget).getDisplay() : DisplayUtils.getDisplay();
        return display;
    }

    public static <T> T executeInUserInterfaceThread(Callable<T> action) throws InterruptedException, ExecutionException {
        return DisplayUtils.executeInUserInterfaceThread(DEFAULT_DISPLAY, action);
    }

    public static void executeInUserInterfaceThread(final Runnable action) throws InterruptedException, ExecutionException {
        DisplayUtils.executeInUserInterfaceThread(DEFAULT_DISPLAY, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                action.run();
                return null;
            }
        });
    }

    public static <T> T executeInUserInterfaceThread(UISynchronize ui, Callable<T> action) throws InterruptedException, ExecutionException {
        if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
            FutureTask<T> task = new FutureTask<T>(action);
            try {
                ui.syncExec(task);
            }
            catch (SWTException e) {
                throw new ExecutionException(e.getCause());
            }
            return task.get();
        }
        try {
            return action.call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public static <T> T executeBusy(Callable<T> action) throws InterruptedException, ExecutionException {
        return DisplayUtils.executeBusy(DEFAULT_DISPLAY, action);
    }

    public static void executeBusy(final Runnable action) throws InterruptedException, ExecutionException {
        DisplayUtils.executeBusy(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                action.run();
                return null;
            }
        });
    }

    public static <T> T executeBusy(UISynchronize ui, Callable<T> action) throws InterruptedException, ExecutionException {
        final FutureTask<T> task = new FutureTask<T>(action);
        final Display display = Display.findDisplay((Thread)Thread.currentThread());
        if (display == null) {
            task.run();
        } else {
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Future<?> future = BACKGROUND_EXECUTOR.submit(task);
                    while (!future.isDone() && !display.isDisposed()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            });
        }
        return task.get();
    }

    public static Display getDisplay() {
        Display display = null;
        display = Display.getDefault();
        if (display == null) {
            logger.info((Object)"Default Display is null.");
            display = Display.getCurrent();
            if (display == null) {
                logger.info((Object)"Current Display is null.");
                try {
                    display = PlatformUI.getWorkbench().getDisplay();
                    if (display == null) {
                        logger.info((Object)"PlatformUI Display is null.");
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
        }
        if (display == null) {
            logger.warn((Object)"Display is null!");
        }
        return display;
    }

    public static Shell getShell(Widget widget) {
        Shell shell = null;
        shell = widget instanceof Control ? ((Control)widget).getShell() : DisplayUtils.getShell();
        return shell;
    }

    public static Shell getShell() {
        if (Display.getCurrent() == null) {
            logger.error((Object)"Try to access shell outside of UI-Thread!");
            Thread.dumpStack();
            return null;
        }
        Shell shell = null;
        Display display = DisplayUtils.getDisplay();
        if (display != null) {
            try {
                shell = display.getActiveShell();
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (shell == null) {
            if (display != null) {
                Shell[] shells;
                Shell[] shellArray = shells = display.getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ignoreDialog;
                    Shell s = shellArray[n2];
                    if (!(s.isDisposed() || !s.isVisible() || (ignoreDialog = s.getData("org.eclipse.e4.ui.ignoreDialog")) instanceof Boolean && ((Boolean)ignoreDialog).booleanValue())) {
                        return s;
                    }
                    ++n2;
                }
            }
            logger.error((Object)"Shell is null!");
        }
        return shell;
    }

    public static Shell getShell(Event event) {
        Widget widget = event.widget;
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof ToolItem) {
            return ((ToolItem)widget).getParent().getShell();
        }
        if (widget instanceof MenuItem) {
            return ((MenuItem)widget).getParent().getShell();
        }
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getParent().getShell();
        }
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getParent().getShell();
        }
        return null;
    }
}

