/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.edit.EditValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextEdit
extends EditValue<List<String>> {
    private final Text text;
    private final List<String> initialValues = new ArrayList<String>();
    private List<String> editedValues = new CopyOnWriteArrayList<String>();

    public MultiLineTextEdit(Composite parent, Collection<String> initialText) {
        if (initialText == null) {
            initialText = Collections.emptyList();
        }
        this.initialValues.addAll(initialText);
        this.editedValues.addAll(this.initialValues);
        this.text = ControlBuilder.fill(new Text(parent, 2626));
        ControlBuilder.gridData((Control)this.text).heightHint = 100;
        this.text.setText(String.join((CharSequence)Text.DELIMITER, this.initialValues));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MultiLineTextEdit.this.editedValues.clear();
                MultiLineTextEdit.this.editedValues.addAll(Arrays.asList(MultiLineTextEdit.this.text.getText().split(Text.DELIMITER)));
                MultiLineTextEdit.this.setChanged();
                MultiLineTextEdit.this.notifyObservers(MultiLineTextEdit.this.editedValues);
            }
        });
    }

    @Override
    public boolean isEdited() {
        return !this.editedValues.equals(this.initialValues);
    }

    @Override
    public List<String> getValue() {
        return this.editedValues;
    }

    @Override
    public Control getControl() {
        return this.text;
    }
}

