/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.database.AbstractDatabaseExportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.csv.internal.converter.SpecificationValidator;
import org.eclipse.chemclipse.msd.converter.supplier.csv.io.core.MassSpectrumWriter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class DatabaseExportConverter
extends AbstractDatabaseExportConverter {
    private static final Logger logger = Logger.getLogger(DatabaseExportConverter.class);
    private static final String DESCRIPTION = "CSV Mass Spectrum Export";

    public IProcessingInfo convert(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidator.validateSpecification(file, "csv"), massSpectrum);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                MassSpectrumWriter massSpectraWriter = new MassSpectrumWriter();
                massSpectraWriter.write(file, massSpectrum, append, monitor);
                processingInfo.setProcessingResult((Object)file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IProcessingInfo convert(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidator.validateSpecification(file, "csv"), massSpectra);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                MassSpectrumWriter massSpectraWriter = new MassSpectrumWriter();
                massSpectraWriter.write(file, massSpectra, append, monitor);
                processingInfo.setProcessingResult((Object)file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IScanMSD massSpectrum) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(massSpectrum));
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IMassSpectra massSpectra) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(massSpectra));
        return processingInfo;
    }
}

