/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.axis;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.internal.ChartLayoutData;
import org.eclipse.swtchart.internal.Util;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.axis.Messages;

public class AxisTickLabels
implements PaintListener {
    private final Chart chart;
    private final Axis axis;
    private Color foreground;
    private int widthHint;
    private int heightHint;
    private Rectangle bounds;
    private final ArrayList<Double> tickLabelValues;
    private final ArrayList<String> tickLabels;
    private final ArrayList<Integer> tickLabelPositions;
    private final ArrayList<Boolean> tickVisibilities;
    private Format format;
    private static final int DEFAULT_FOREGROUND = 9;
    private static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    private static final String DEFAULT_DECIMAL_FORMAT = "#.###########";
    private Map<Integer, Integer[]> possibleTickSteps;
    private Font font;

    protected AxisTickLabels(Chart chart, Axis axis) {
        this.chart = chart;
        this.axis = axis;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickVisibilities = new ArrayList();
        this.initializePossibleTickSteps();
        this.font = DEFAULT_FONT;
        this.foreground = Display.getDefault().getSystemColor(9);
        chart.addPaintListener(this);
    }

    private void initializePossibleTickSteps() {
        Integer[] milliseconds = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 999};
        Integer[] seconds = new Integer[]{1, 2, 5, 10, 15, 20, 30, 59};
        Integer[] minutes = new Integer[]{1, 2, 3, 5, 10, 15, 20, 30, 59};
        Integer[] hours = new Integer[]{1, 2, 3, 4, 6, 12, 22};
        Integer[] dates = new Integer[]{1, 7, 14, 28};
        Integer[] months = new Integer[]{1, 2, 3, 4, 6, 11};
        Integer[] years = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000};
        this.possibleTickSteps = new HashMap<Integer, Integer[]>();
        this.possibleTickSteps.put(14, milliseconds);
        this.possibleTickSteps.put(13, seconds);
        this.possibleTickSteps.put(12, minutes);
        this.possibleTickSteps.put(11, hours);
        this.possibleTickSteps.put(5, dates);
        this.possibleTickSteps.put(2, months);
        this.possibleTickSteps.put(1, years);
    }

    public void setForeground(Color color) {
        this.foreground = color == null ? Display.getDefault().getSystemColor(9) : color;
    }

    protected Color getForeground() {
        if (this.foreground.isDisposed()) {
            this.foreground = Display.getDefault().getSystemColor(9);
        }
        return this.foreground;
    }

    protected void update(int length) {
        this.tickLabelValues.clear();
        this.tickLabels.clear();
        this.tickLabelPositions.clear();
        if (this.axis.isValidCategoryAxis()) {
            this.updateTickLabelForCategoryAxis(length);
        } else if (this.axis.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(length);
        } else {
            this.updateTickLabelForLinearScale(length);
        }
        this.updateTickVisibility();
    }

    private void updateTickLabelForCategoryAxis(int length) {
        String[] series = this.axis.getCategorySeries();
        if (series == null) {
            return;
        }
        int max = (int)this.axis.getRange().upper;
        int min = (int)this.axis.getRange().lower;
        int sizeOfTickLabels = series.length < max - min + 1 ? series.length : max - min + 1;
        int initialIndex = min < 0 ? 0 : min;
        int i = 0;
        while (i < sizeOfTickLabels) {
            this.tickLabels.add(series[i + initialIndex]);
            int tickLabelPosition = (int)((double)length * ((double)i + 0.5) / (double)sizeOfTickLabels);
            if (this.axis.isReversed()) {
                tickLabelPosition = this.correctPositionInReversedAxis(tickLabelPosition);
            }
            this.tickLabelPositions.add(tickLabelPosition);
            ++i;
        }
    }

    private void updateTickLabelForLogScale(int length) {
        BigDecimal tickStep;
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        int digitMin = (int)Math.ceil(Math.log10(min));
        int digitMax = (int)Math.ceil(Math.log10(max));
        BigDecimal MIN = BigDecimal.valueOf(min);
        BigDecimal firstPosition = MIN.remainder(tickStep = AxisTickLabels.pow(10.0, digitMin - 1)).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep);
        int i = digitMin;
        while (i <= digitMax) {
            BigDecimal j = firstPosition;
            while (j.doubleValue() <= AxisTickLabels.pow(10.0, i).doubleValue()) {
                if (j.doubleValue() > max) break;
                this.tickLabels.add(this.format(j.doubleValue()));
                this.tickLabelValues.add(j.doubleValue());
                int tickLabelPosition = (int)((Math.log10(j.doubleValue()) - Math.log10(min)) / (Math.log10(max) - Math.log10(min)) * (double)length);
                if (this.axis.isReversed()) {
                    tickLabelPosition = this.correctPositionInReversedAxis(tickLabelPosition);
                }
                this.tickLabelPositions.add(tickLabelPosition);
                j = j.add(tickStep);
            }
            tickStep = tickStep.multiply(AxisTickLabels.pow(10.0, 1));
            firstPosition = tickStep.add(AxisTickLabels.pow(10.0, i));
            ++i;
        }
    }

    private void updateTickLabelForLinearScale(int length) {
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        this.updateTickLabelForLinearScale(length, this.getGridStep(length, min, max));
    }

    private void updateTickLabelForLinearScale(int length, BigDecimal tickStep) {
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        BigDecimal MIN = BigDecimal.valueOf(min);
        BigDecimal firstPosition = MIN.remainder(tickStep).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep);
        BigDecimal b = firstPosition;
        while (b.doubleValue() <= max) {
            this.tickLabels.add(this.format(b.doubleValue()));
            this.tickLabelValues.add(b.doubleValue());
            int tickLabelPosition = (int)((b.doubleValue() - min) / (max - min) * (double)length);
            if (this.axis.isReversed()) {
                tickLabelPosition = this.correctPositionInReversedAxis(tickLabelPosition);
            }
            this.tickLabelPositions.add(tickLabelPosition);
            b = b.add(tickStep);
        }
    }

    private int correctPositionInReversedAxis(int position) {
        Point plotAreaBounds = this.chart.getPlotArea().getSize();
        if (this.axis.isHorizontalAxis()) {
            return plotAreaBounds.x - position - 1;
        }
        return plotAreaBounds.y - position - 1;
    }

    private void updateTickVisibility() {
        this.tickVisibilities.clear();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickVisibilities.add(Boolean.TRUE);
            ++i;
        }
        if (this.tickLabelPositions.size() == 0 || this.axis.getTick().getTickLabelAngle() != 0) {
            return;
        }
        int previousPosition = 0;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            boolean hasSpaceToDraw = true;
            if (i2 != 0) {
                hasSpaceToDraw = this.hasSpaceToDraw(previousPosition, this.tickLabelPositions.get(i2), this.tickLabels.get(i2));
            }
            boolean isMajorTick = true;
            if (!this.axis.isValidCategoryAxis()) {
                if (this.axis.isLogScaleEnabled()) {
                    isMajorTick = this.isMajorTick(this.tickLabelValues.get(i2));
                }
                String currentLabel = this.tickLabels.get(i2);
                try {
                    double value = this.parse(currentLabel);
                    if (value != this.tickLabelValues.get(i2)) {
                        isMajorTick = false;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (hasSpaceToDraw && isMajorTick) {
                previousPosition = this.tickLabelPositions.get(i2);
            } else {
                this.tickVisibilities.set(i2, Boolean.FALSE);
            }
            ++i2;
        }
    }

    private String format(Object obj) {
        if (this.format == null) {
            return new DecimalFormat(DEFAULT_DECIMAL_FORMAT).format(obj);
        }
        return this.format.format(obj);
    }

    private double parse(String label) throws ParseException {
        if (this.format == null) {
            return new DecimalFormat(DEFAULT_DECIMAL_FORMAT).parse(label).doubleValue();
        }
        Object parsed = this.format.parseObject(label);
        if (!(parsed instanceof Number)) {
            throw new ParseException(label, 0);
        }
        return ((Number)parsed).doubleValue();
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.axis.isLogScaleEnabled()) {
            return true;
        }
        return Math.log10(tickValue) % 1.0 == 0.0;
    }

    private boolean hasSpaceToDraw(int previousPosition, int tickLabelPosition, String tickLabel) {
        int padding;
        int textLength;
        Point p = Util.getExtentInGC(this.axis.getTick().getFont(), tickLabel);
        int interval = Math.abs(tickLabelPosition - previousPosition);
        return interval > (textLength = this.axis.isHorizontalAxis() ? p.x : p.y) + (padding = 3);
    }

    public int getRightMarginHint(int length) {
        int mostRightLabelIndex = -1;
        int i = this.tickLabels.size() - 1;
        while (i >= 0) {
            if (this.tickVisibilities.size() > i && this.tickVisibilities.get(i).booleanValue()) {
                mostRightLabelIndex = i;
                break;
            }
            --i;
        }
        int rightMarginHint = 0;
        if (mostRightLabelIndex != -1) {
            int position = this.tickLabelPositions.get(mostRightLabelIndex);
            double angle = this.axis.getTick().getTickLabelAngle();
            int textWidth = Util.getExtentInGC((Font)this.axis.getTick().getFont(), (String)this.tickLabels.get((int)mostRightLabelIndex)).x;
            if (angle == 0.0) {
                rightMarginHint = Math.max(0, position - length + (int)((double)textWidth / 2.0));
            } else if (this.axis.getPosition() == IAxis.Position.Secondary) {
                rightMarginHint = Math.max(0, position - length + (int)((double)textWidth * Math.cos(Math.toRadians(angle))));
            }
        }
        return rightMarginHint;
    }

    public int getLeftMarginHint(int length) {
        int mostLeftLabelIndex = -1;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickVisibilities.size() > i && this.tickVisibilities.get(i).booleanValue()) {
                mostLeftLabelIndex = i;
                break;
            }
            ++i;
        }
        int leftMarginHint = 0;
        if (mostLeftLabelIndex != -1) {
            int position = this.tickLabelPositions.get(mostLeftLabelIndex);
            double angle = this.axis.getTick().getTickLabelAngle();
            int textWidth = Util.getExtentInGC((Font)this.axis.getTick().getFont(), (String)this.tickLabels.get((int)mostLeftLabelIndex)).x;
            if (angle == 0.0) {
                leftMarginHint = Math.max(0, (int)((double)textWidth / 2.0) - position);
            } else if (this.axis.getPosition() == IAxis.Position.Primary) {
                leftMarginHint = Math.max(0, (int)((double)textWidth * Math.cos(Math.toRadians(angle))) - position);
            }
        }
        return leftMarginHint;
    }

    public int getTickLabelMaxLength() {
        int maxLength = 0;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickVisibilities.size() > i && this.tickVisibilities.get(i).booleanValue()) {
                Point p = Util.getExtentInGC(this.axis.getTick().getFont(), this.tickLabels.get(i));
                if (p.x > maxLength) {
                    maxLength = p.x;
                }
            }
            ++i;
        }
        return maxLength;
    }

    private static BigDecimal pow(double base, int exponent) {
        BigDecimal value = exponent > 0 ? BigDecimal.valueOf(base).pow(exponent) : BigDecimal.ONE.divide(BigDecimal.valueOf(base).pow(-exponent));
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private BigDecimal getGridStep(int lengthInPixels, double min, double max) {
        block10: {
            if (lengthInPixels <= 0) {
                throw new IllegalArgumentException(Messages.getString("LENGTH_MUST_BE_POSITIVE"));
            }
            if (min >= max) {
                throw new IllegalArgumentException(Messages.getString("MUST_BE_LESS_MAX"));
            }
            length = Math.abs(max - min);
            mantissa = gridStepHint = length / (double)lengthInPixels * (double)this.axis.getTick().getTickMarkStepHint();
            exponent = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl16
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exponent;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exponent;
lbl16:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? BigDecimal.TEN.multiply(AxisTickLabels.pow(10.0, exponent)) : (mantissa > 3.5 ? BigDecimal.valueOf(5L).multiply(AxisTickLabels.pow(10.0, exponent)) : (mantissa > 1.5 ? BigDecimal.valueOf(2L).multiply(AxisTickLabels.pow(10.0, exponent)) : AxisTickLabels.pow(10.0, exponent)));
        if (this.axis.isIntegerDataPointAxis()) {
            var17_9 = this.chart.getSeriesSet().getSeries();
            var16_10 = var17_9.length;
            var15_11 = 0;
            while (var15_11 < var16_10) {
                series = var17_9[var15_11];
                if (this.axis.getDirection() == IAxis.Direction.X) {
                    if (series.getXAxisId() == this.axis.getId() && series.getXSeries().length != 0) {
                        xSeriesLength = series.getXSeries().length;
                        upper = series.getXSeries()[xSeriesLength - 1];
                        lower = series.getXSeries()[0];
                        gridStep = BigDecimal.valueOf((upper - lower) / (double)(xSeriesLength - 1));
                    }
                } else if (series.getYAxisId() == this.axis.getId() && series.getYSeries().length != 0) {
                    gridStep = BigDecimal.valueOf(1.0);
                }
                ++var15_11;
            }
        }
        return gridStep;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    protected ArrayList<Double> getTickLabelValues() {
        return this.tickLabelValues;
    }

    protected void setFont(Font font) {
        this.font = font == null ? DEFAULT_FONT : font;
    }

    public Font getFont() {
        if (this.font.isDisposed()) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public ChartLayoutData getLayoutData() {
        return new ChartLayoutData(this.widthHint, this.heightHint);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void dispose() {
        if (!this.chart.isDisposed()) {
            this.chart.removePaintListener(this);
        }
    }

    protected void updateLayoutData() {
        this.widthHint = -1;
        this.heightHint = -1;
        if (!this.axis.getTick().isVisible()) {
            this.widthHint = 0;
            this.heightHint = 0;
        } else if (this.axis.isHorizontalAxis()) {
            this.heightHint = 5 + Util.getExtentInGC((Font)this.getFont(), null).y;
        } else {
            this.widthHint = 5;
        }
    }

    public void paintControl(PaintEvent e) {
        if (!this.axis.getTick().isVisible()) {
            return;
        }
        Color oldBackground = e.gc.getBackground();
        e.gc.setBackground(this.chart.getBackground());
        Color oldForeground = e.gc.getForeground();
        e.gc.setForeground(this.getForeground());
        if (this.axis.isHorizontalAxis()) {
            this.drawXTick(e.gc);
        } else {
            this.drawYTick(e.gc);
        }
        e.gc.setBackground(oldBackground);
        e.gc.setForeground(oldForeground);
    }

    private void drawXTick(GC gc) {
        int offset = this.axis.getTick().getAxisTickMarks().getBounds().x;
        gc.setFont(this.axis.getTick().getFont());
        int angle = this.axis.getTick().getTickLabelAngle();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.axis.isValidCategoryAxis() || this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int textWidth = gc.textExtent((String)text).x;
                int textHeight = gc.textExtent((String)text).y;
                if (angle == 0) {
                    int x = (int)((double)this.tickLabelPositions.get(i).intValue() - (double)textWidth / 2.0 + (double)offset);
                    gc.drawText(text, this.bounds.x + x, this.bounds.y);
                } else {
                    float y;
                    float x;
                    if (this.axis.getPosition() == IAxis.Position.Primary) {
                        x = (float)((double)(offset + this.bounds.x + this.tickLabelPositions.get(i)) - (double)textWidth * Math.cos(Math.toRadians(angle)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)this.bounds.y + (double)textWidth * Math.sin(Math.toRadians(angle)));
                    } else {
                        x = (float)((double)(offset + this.bounds.x + this.tickLabelPositions.get(i)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)this.bounds.y + (double)this.bounds.height * Math.sin(Math.toRadians(angle)));
                    }
                    AxisTickLabels.drawRotatedText(gc, text, x, y, angle);
                }
            }
            ++i;
        }
    }

    private static void drawRotatedText(GC gc, String text, float x, float y, int angle) {
        Transform transform = new Transform(gc.getDevice());
        transform.translate(x, y);
        transform.rotate((float)(360 - angle));
        gc.setTransform(transform);
        gc.drawText(text, 0, 0);
        transform.dispose();
        gc.setTransform(null);
    }

    private void drawYTick(GC gc) {
        int margin = 10;
        gc.setFont(this.axis.getTick().getFont());
        int figureHeight = gc.textExtent((String)"dummy").y;
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.size() == 0 || this.tickLabels.size() == 0) break;
            if (this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int x = 5;
                if (this.tickLabels.get(0).startsWith("-") && !text.startsWith("-")) {
                    x += gc.textExtent((String)"-").x;
                }
                int y = (int)((double)(this.bounds.height - 1 - this.tickLabelPositions.get(i)) - (double)figureHeight / 2.0 - (double)margin);
                gc.drawText(text, this.bounds.x + x, this.bounds.y + y);
            }
            ++i;
        }
    }

    protected void setFormat(Format format) {
        this.format = format;
    }

    protected Format getFormat() {
        return this.format;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        return this.tickVisibilities;
    }

    public ArrayList<String> getTickLabels() {
        return this.tickLabels;
    }
}

