/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.result.IDenoisingFilterResult;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FilterModifier
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(FilterModifier.class);
    private static final String DESCRIPTION = "Denoising Filter";
    private static final String FILTER_ID = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising";

    public FilterModifier(IChromatogramSelectionMSD chromatogramSelection) {
        super((IChromatogramSelection)chromatogramSelection);
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() instanceof IChromatogramSelectionMSD) {
            final IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)this.getChromatogramSelection();
            try {
                IProcessingInfo processingInfo = ChromatogramFilterMSD.applyFilter((IChromatogramSelectionMSD)chromatogramSelection, (String)FILTER_ID, (IProgressMonitor)monitor);
                IChromatogramFilterResult result = (IChromatogramFilterResult)processingInfo.getProcessingResult();
                if (result instanceof IDenoisingFilterResult) {
                    ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
                    DisplayUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            chromatogramSelection.reset(true);
                        }
                    });
                }
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

