/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.progress;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class ProgressMonitoringCallable<T>
implements Callable<T> {
    private BiConsumer<Double, Double> progressConsumer;
    private Consumer<String> progressMessageConsumer;

    public BiConsumer<Double, Double> getProgressConsumer() {
        return this.progressConsumer;
    }

    public void updateProgress(double cnt, double total) {
        if (this.progressConsumer != null) {
            this.progressConsumer.accept(cnt, total);
        }
    }

    public void updateMessage(String message) {
        if (this.progressMessageConsumer != null) {
            this.progressMessageConsumer.accept(message);
        }
    }

    public void updateProgress(long cnt, long total) {
        this.updateProgress((double)cnt, (double)total);
    }

    public Consumer<String> getProgressMessageConsumer() {
        return this.progressMessageConsumer;
    }

    public ProgressMonitoringCallable<T> setProgressConsumer(BiConsumer<Double, Double> progressConsumer) {
        this.progressConsumer = progressConsumer;
        return this;
    }

    public ProgressMonitoringCallable<T> setProgressMessageConsumer(Consumer<String> progressMessageConsumer) {
        this.progressMessageConsumer = progressMessageConsumer;
        return this;
    }
}

