/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.evaluator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.ChromatogramClassifier;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ClassifierEvaluator
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "WNC Classifier";
    private static final String FILTER_ID = "org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc";

    public ClassifierEvaluator(IChromatogramSelectionMSD chromatogramSelection) {
        super((IChromatogramSelection)chromatogramSelection);
    }

    public void execute(IProgressMonitor monitor) {
        IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            IProcessingInfo processingInfo = ChromatogramClassifier.applyClassifier((IChromatogramSelection)((IChromatogramSelectionMSD)chromatogramSelection), (String)FILTER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            chromatogramSelection.update(true);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, false, false, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

