/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.Objects;
import org.eclipse.chemclipse.wsd.model.xwc.IWavelengthRange;

public class WavelengthRange
implements IWavelengthRange {
    private double startWavelength;
    private double stopWavelength;

    public WavelengthRange(double startWavelength, double stopWavelength) {
        if (startWavelength > stopWavelength) {
            double tmp = startWavelength;
            startWavelength = stopWavelength;
            stopWavelength = tmp;
        }
        if (startWavelength < 100.0 || startWavelength > 1000.0) {
            startWavelength = 100.0;
        }
        if (stopWavelength > 1000.0 || stopWavelength < 100.0) {
            stopWavelength = 1000.0;
        }
        this.startWavelength = startWavelength;
        this.stopWavelength = stopWavelength;
    }

    @Override
    public double getStartWavelength() {
        return this.startWavelength;
    }

    @Override
    public double getStopWavelength() {
        return this.stopWavelength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        WavelengthRange otherRange = (WavelengthRange)other;
        return this.getStartWavelength() == otherRange.getStartWavelength() && this.getStopWavelength() == otherRange.getStopWavelength();
    }

    public int hashCode() {
        return Objects.hash(this.startWavelength, this.stopWavelength);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startWavelength=" + this.getStartWavelength());
        builder.append(",");
        builder.append("stopWavelength=" + this.getStopWavelength());
        builder.append("]");
        return builder.toString();
    }
}

