/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components.scan;

import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.swt.ui.components.AbstractProfileScanUI;
import org.eclipse.chemclipse.wsd.swt.ui.converter.SeriesConverterWSD;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ProfileScanUI
extends AbstractProfileScanUI {
    public ProfileScanUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        IChromatogramSelectionWSD chromatogramSelection = this.getChromatogramSelection();
        IScanWSD supplierScan = chromatogramSelection.getSelectedScan();
        if (supplierScan != null) {
            ISeries series = SeriesConverterWSD.convertSupplierScan(supplierScan, Sign.POSITIVE);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.RED);
        }
    }
}

