/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components.scan;

import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.notifier.IChromatogramSelectionWSDUpdateNotifier;
import org.eclipse.chemclipse.wsd.swt.ui.components.scan.AbstractExtendedScan;
import org.eclipse.chemclipse.wsd.swt.ui.converter.SeriesConverterWSD;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class CentroidScanUI
extends AbstractExtendedScan
implements IChromatogramSelectionWSDUpdateNotifier {
    public CentroidScanUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        if (this.supplierScan != null) {
            ISeries series = SeriesConverterWSD.convertSupplierScan(this.supplierScan, Sign.POSITIVE);
            this.multipleLineSeries.add(series);
            IBarSeries barSeries = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, series.getId());
            barSeries.setXSeries(series.getXSeries());
            barSeries.setYSeries(series.getYSeries());
            barSeries.setBarWidthStyle(IBarSeries.BarWidthStyle.FIXED);
            barSeries.setBarWidth(1);
            barSeries.setBarColor(Colors.RED);
        }
    }

    public void update(IChromatogramSelectionWSD chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        this.supplierScan = chromatogramSelection.getSelectedScan();
        if (!this.master || this.master && forceReload) {
            this.setSeries(forceReload);
        }
    }
}

