/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import org.eclipse.chemclipse.support.ui.preferences.editors.IonInputValidator;
import org.eclipse.chemclipse.support.util.IonListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class IonListEditor
extends ListEditor {
    public IonListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        Composite composite = this.getButtonBoxControl(parent);
        Button button = new Button(composite, 8);
        button.setText("Clear List");
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = IonListEditor.this.getList();
                if (list != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 448);
                    messageBox.setText("Delete Ions");
                    messageBox.setMessage("Do you really want to delete all ions from the list?");
                    int decision = messageBox.open();
                    if (decision == 64) {
                        list.removeAll();
                    }
                }
            }
        });
    }

    protected String createList(String[] items) {
        IonListUtil ionListUtil = new IonListUtil();
        return ionListUtil.createList(items);
    }

    protected String getNewInputObject() {
        List list = this.getList();
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Enter a single ion or an ion range.", "E.g. 104 for styrene or 310 - 340 to add the range.", "", (IInputValidator)new IonInputValidator(list));
        dialog.create();
        dialog.open();
        String ions = dialog.getValue();
        return this.addIonsAndGetReturnValue(ions, list);
    }

    private String addIonsAndGetReturnValue(String ions, List list) {
        String[] items = list.getItems();
        String[] ionList = ions.trim().split("-");
        String ion = "";
        if (ionList.length == 1) {
            ion = ionList[0].trim();
        } else if (ionList.length == 2) {
            int stopIon;
            int startIon = Integer.parseInt(ionList[0].trim());
            if (startIon > (stopIon = Integer.parseInt(ionList[1].trim()))) {
                int tmp = startIon;
                startIon = stopIon;
                stopIon = tmp;
            }
            ion = Integer.toString(stopIon);
            int i = stopIon - 1;
            while (i >= startIon) {
                String item = Integer.toString(i);
                if (this.itemDoesNotExistsInList(items, item)) {
                    list.add(item);
                }
                --i;
            }
        }
        return ion;
    }

    private boolean itemDoesNotExistsInList(String[] items, String item) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String itemx = stringArray[n2];
            if (itemx.equals(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String[] parseString(String stringList) {
        IonListUtil ionListUtil = new IonListUtil();
        return ionListUtil.parseString(stringList);
    }
}

