/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.IPeakCSDSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.PeakType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractPeakCSDSelectionView
extends AbstractSelectionView
implements IPeakCSDSelectionView {
    private IPeakCSD peak;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractPeakCSDSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IPeakCSD getPeak() {
        if (this.peak == null) {
            this.peak = PeakType.getSelectedPeakCSD();
        }
        return this.peak;
    }

    @Override
    public void setPeak(IPeakCSD peak) {
        this.peak = peak;
    }

    @Override
    public boolean doUpdate(IPeakCSD peak) {
        return this.isPartVisible() && peak != null;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractPeakCSDSelectionView.this.peak = (IPeakCSD)event.getProperty("PeakCSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractPeakCSDSelectionView.this.update(AbstractPeakCSDSelectionView.this.peak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/peak", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

