/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image uncheckedImg;

    public CheckBoxPainter() {
        this.checkedImg = GUIHelper.getImage("checked");
        this.uncheckedImg = GUIHelper.getImage("unchecked");
    }

    public CheckBoxPainter(Image checkedImg, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.uncheckedImg = uncheckedImg;
    }

    public int getPreferredWidth(boolean checked) {
        return this.getImage((boolean)checked).getBounds().width;
    }

    public int getPreferredHeight(boolean checked) {
        return this.getImage((boolean)checked).getBounds().height;
    }

    public void paintIconImage(GC gc, Rectangle rectangle, int yOffset, boolean checked) {
        Image checkBoxImage = this.getImage(checked);
        int x = rectangle.x + rectangle.width / 2 - checkBoxImage.getBounds().width / 2;
        gc.drawImage(checkBoxImage, x, rectangle.y + yOffset);
    }

    public Image getImage(boolean checked) {
        return checked ? this.checkedImg : this.uncheckedImg;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.isChecked(cell, configRegistry) ? this.checkedImg : this.uncheckedImg;
    }

    protected boolean isChecked(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        if (cell.getDataValue() instanceof Boolean) {
            return (Boolean)cell.getDataValue();
        }
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Boolean convertedValue = null;
        if (displayConverter != null) {
            convertedValue = (Boolean)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue());
        }
        if (convertedValue == null) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }
}

