/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocations {
    public static List<Expression> getArguments(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).arguments();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).arguments();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).arguments();
            }
            case 46: {
                return ((SuperConstructorInvocation)invocation).arguments();
            }
            case 14: {
                return ((ClassInstanceCreation)invocation).arguments();
            }
            case 72: {
                return ((EnumConstantDeclaration)invocation).arguments();
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static ChildListPropertyDescriptor getArgumentsProperty(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return MethodInvocation.ARGUMENTS_PROPERTY;
            }
            case 48: {
                return SuperMethodInvocation.ARGUMENTS_PROPERTY;
            }
            case 17: {
                return ConstructorInvocation.ARGUMENTS_PROPERTY;
            }
            case 46: {
                return SuperConstructorInvocation.ARGUMENTS_PROPERTY;
            }
            case 14: {
                return ClassInstanceCreation.ARGUMENTS_PROPERTY;
            }
            case 72: {
                return EnumConstantDeclaration.ARGUMENTS_PROPERTY;
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static Expression getExpression(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).getExpression();
            }
            case 48: {
                return null;
            }
            case 17: {
                return null;
            }
            case 46: {
                return ((SuperConstructorInvocation)invocation).getExpression();
            }
            case 14: {
                return ((ClassInstanceCreation)invocation).getExpression();
            }
            case 72: {
                return null;
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static boolean isInvocation(ASTNode node) {
        int type = node.getNodeType();
        return type == 32 || type == 48 || type == 17;
    }

    public static boolean isInvocationWithArguments(ASTNode node) {
        switch (node.getNodeType()) {
            case 14: 
            case 17: 
            case 32: 
            case 46: 
            case 48: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    public static IMethodBinding resolveBinding(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).resolveMethodBinding();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).resolveMethodBinding();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).resolveConstructorBinding();
            }
            case 46: {
                return ((SuperConstructorInvocation)invocation).resolveConstructorBinding();
            }
            case 14: {
                return ((ClassInstanceCreation)invocation).resolveConstructorBinding();
            }
            case 72: {
                return ((EnumConstantDeclaration)invocation).resolveConstructorBinding();
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static boolean isResolvedTypeInferredFromExpectedType(Expression invocation) {
        if (invocation == null) {
            return false;
        }
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).isResolvedTypeInferredFromExpectedType();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).isResolvedTypeInferredFromExpectedType();
            }
            case 14: {
                return ((ClassInstanceCreation)invocation).isResolvedTypeInferredFromExpectedType();
            }
        }
        return false;
    }

    public static ListRewrite getInferredTypeArgumentsRewrite(ASTRewrite rewrite, Expression invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return rewrite.getListRewrite((ASTNode)invocation, MethodInvocation.TYPE_ARGUMENTS_PROPERTY);
            }
            case 48: {
                return rewrite.getListRewrite((ASTNode)invocation, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY);
            }
            case 14: {
                Type type = ((ClassInstanceCreation)invocation).getType();
                return rewrite.getListRewrite((ASTNode)type, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static ITypeBinding[] getInferredTypeArguments(Expression invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                IMethodBinding methodBinding = ((MethodInvocation)invocation).resolveMethodBinding();
                return methodBinding == null ? null : methodBinding.getTypeArguments();
            }
            case 48: {
                IMethodBinding methodBinding = ((SuperMethodInvocation)invocation).resolveMethodBinding();
                return methodBinding == null ? null : methodBinding.getTypeArguments();
            }
            case 14: {
                Type type = ((ClassInstanceCreation)invocation).getType();
                ITypeBinding typeBinding = type.resolveBinding();
                return typeBinding == null ? null : typeBinding.getTypeArguments();
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }
}

