/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.io.support;

import org.eclipse.chemclipse.converter.io.support.IArrayWriter;

public abstract class AbstractArrayWriter
implements IArrayWriter {
    private int position = 0;
    private byte[] data;

    public AbstractArrayWriter(byte[] data) {
        this.data = data;
    }

    @Override
    public void write(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.data[this.position++] = bytes[i];
            ++i;
        }
    }

    @Override
    public void skipBytes(int bytes) {
        this.position += bytes;
    }

    @Override
    public byte[] getBytesStringTerminated(int writeBytes, String entry) {
        int maxLength = 255;
        if (writeBytes > maxLength) {
            writeBytes = maxLength;
        }
        byte[] bytes = new byte[writeBytes];
        int endIndex = writeBytes - 1;
        if (endIndex > 0) {
            int length = endIndex > entry.length() ? entry.length() : entry.substring(0, endIndex).length();
            byte[] bytesLength = this.get4BytesAsIntegerBigEndian(length);
            byte[] bytesEntry = entry.getBytes();
            bytes[0] = bytesLength[3];
            int i = 1;
            while (i <= length) {
                bytes[i] = bytesEntry[i - 1];
                ++i;
            }
        }
        return bytes;
    }

    @Override
    public byte[] getBytesStringNullTerminated(int writeBytes, String entry) {
        byte[] bytes = new byte[writeBytes *= 2];
        byte[] bytesEntry = entry.getBytes();
        int index = 0;
        int i = 0;
        while (i < bytesEntry.length) {
            if (index < writeBytes) {
                bytes[index++] = bytesEntry[i];
                bytes[index++] = 0;
            }
            ++i;
        }
        return bytes;
    }

    @Override
    public void writeIntegerAsBigEndian(int value) {
        this.write(this.get4BytesAsIntegerBigEndian(value));
    }

    @Override
    public byte[] get2BytesAsShortBigEndian(int value) {
        byte[] bytes = new byte[2];
        int i = 0;
        while (i < 2) {
            int shift = i << 3;
            bytes[1 - i] = (byte)((value & 255 << shift) >>> shift);
            ++i;
        }
        return bytes;
    }

    @Override
    public byte[] get4BytesAsIntegerBigEndian(int value) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            int shift = i << 3;
            bytes[3 - i] = (byte)((value & 255 << shift) >>> shift);
            ++i;
        }
        return bytes;
    }

    @Override
    public void write2BytesUnsignedIntegerLittleEndian(int value) {
        this.write(this.get2BytesLittleEndian(value));
    }

    @Override
    public void write4BytesUnsignedIntegerLittleEndian(int value) {
        this.write(this.get4BytesLittleEndian(value));
    }

    @Override
    public void write8BytesUnsignedLittleEndian(long value) {
        this.write(this.get8BytesLittleEndian(value));
    }

    @Override
    public byte[] get2BytesLittleEndian(int value) {
        byte[] bytes = new byte[2];
        int i = 0;
        while (i < 2) {
            int shift = i * 8;
            bytes[i] = (byte)(value >>> shift);
            ++i;
        }
        return bytes;
    }

    @Override
    public byte[] get4BytesLittleEndian(int value) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            int shift = i * 8;
            bytes[i] = (byte)(value >>> shift);
            ++i;
        }
        return bytes;
    }

    @Override
    public byte[] get8BytesLittleEndian(long value) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            int shift = i * 8;
            bytes[i] = (byte)(value >>> shift);
            ++i;
        }
        return bytes;
    }
}

