/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.AbstractNoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.exceptions.SegmentNotAcceptedException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.AnalysisSupport;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class DefaultNoiseCalculator
extends AbstractNoiseCalculator
implements INoiseCalculator {
    private static final Logger logger = Logger.getLogger(DefaultNoiseCalculator.class);
    private IChromatogram chromatogram;
    private int segmentWidth;
    private boolean recalculate = false;
    private float noiseValue = 0.0f;

    public void setChromatogram(IChromatogram chromatogram, int segmentWidth) {
        this.chromatogram = chromatogram;
        this.segmentWidth = segmentWidth;
        this.recalculate = true;
    }

    public void recalculate() {
        this.recalculate = true;
    }

    public float getSignalToNoiseRatio(float intensity) {
        if (this.recalculate && this.chromatogram != null) {
            this.noiseValue = this.calculateNoiseFactorByDyson(this.chromatogram);
            this.recalculate = false;
        }
        if (this.noiseValue != 0.0f) {
            return intensity / this.noiseValue;
        }
        return 0.0f;
    }

    private float calculateNoiseFactorByDyson(IChromatogram chromatogram) {
        float noiseValue = 0.0f;
        SegmentValidator segmentValidator = new SegmentValidator();
        try {
            TotalScanSignals signals = new TotalScanSignals(chromatogram);
            AnalysisSupport analysisSupport = new AnalysisSupport(chromatogram.getNumberOfScans(), this.segmentWidth);
            List segments = analysisSupport.getAnalysisSegments();
            noiseValue = this.performNoiseFactorCalculation(segments, segmentValidator, (ITotalScanSignals)signals);
            if (noiseValue == 0.0f) {
                analysisSupport = new AnalysisSupport(chromatogram.getNumberOfScans(), SegmentWidth.WIDTH_5.getWidth());
                segments = analysisSupport.getAnalysisSegments();
                noiseValue = this.performNoiseFactorCalculation(segments, segmentValidator, (ITotalScanSignals)signals);
            }
        }
        catch (AnalysisSupportException e) {
            noiseValue = 0.0f;
            logger.warn((Object)e);
        }
        catch (ChromatogramIsNullException e) {
            noiseValue = 0.0f;
            logger.warn((Object)e);
        }
        if (noiseValue == 0.0f) {
            noiseValue = chromatogram.getMinSignal();
        }
        return noiseValue;
    }

    private float performNoiseFactorCalculation(List<IAnalysisSegment> segments, SegmentValidator segmentValidator, ITotalScanSignals signals) {
        double noiseValue = 0.0;
        ArrayList<Double> deltaNoiseHeights = new ArrayList<Double>();
        for (IAnalysisSegment segment : segments) {
            try {
                noiseValue = this.getDeltaNoiseHeight(segment, segmentValidator, signals);
                deltaNoiseHeights.add(noiseValue);
            }
            catch (SegmentNotAcceptedException segmentNotAcceptedException) {}
        }
        double[] values = new double[deltaNoiseHeights.size()];
        int counter = 0;
        Iterator iterator = deltaNoiseHeights.iterator();
        while (iterator.hasNext()) {
            double deltaNoiseHeight = (Double)iterator.next();
            values[counter++] = deltaNoiseHeight;
        }
        double medianNoiseHeight = Calculations.getMedian((double[])values);
        return (float)medianNoiseHeight;
    }

    private double getDeltaNoiseHeight(IAnalysisSegment segment, SegmentValidator segmentValidator, ITotalScanSignals signals) throws SegmentNotAcceptedException {
        int segmentWidth = segment.getSegmentWidth();
        if (segmentWidth < 1) {
            throw new SegmentNotAcceptedException("The segment width must be greater than 0.");
        }
        double[] values = new double[segmentWidth];
        int counter = 0;
        int scan = segment.getStartScan();
        while (scan <= segment.getStopScan()) {
            ITotalScanSignal signal = signals.getTotalScanSignal(scan);
            values[counter] = signal.getTotalSignal();
            ++counter;
            ++scan;
        }
        double mean = Calculations.getMean((double[])values);
        if (!segmentValidator.acceptSegment(values, mean)) {
            throw new SegmentNotAcceptedException();
        }
        double highestValue = Calculations.getMax((double[])values);
        double lowestValue = Calculations.getMin((double[])values);
        return highestValue - lowestValue;
    }
}

