/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionGroup;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.implementation.IonTransition;
import org.eclipse.chemclipse.msd.model.implementation.IonTransitionGroup;

public abstract class AbstractIonTransitionSettings
implements IIonTransitionSettings {
    private List<IIonTransitionGroup> ionTransitionGroups = new ArrayList<IIonTransitionGroup>();

    @Override
    public IIonTransition getIonTransition(double filter1FirstIon, double filter1LastIon, double filter3FirstIon, double filter3LastIon, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup) {
        return this.getIonTransition("", filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
    }

    @Override
    public IIonTransition getIonTransition(String compoundName, double filter1FirstIon, double filter1LastIon, double filter3FirstIon, double filter3LastIon, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup) {
        IonTransition ionTransition = new IonTransition(filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup, compoundName);
        if (this.size() <= transitionGroup) {
            IonTransitionGroup ionTransitionGroup = new IonTransitionGroup();
            ionTransitionGroup.add(ionTransition);
            this.ionTransitionGroups.add(ionTransitionGroup);
            return ionTransition;
        }
        IIonTransitionGroup ionTransitionGroup = this.ionTransitionGroups.get(transitionGroup);
        if (ionTransitionGroup.contains(ionTransition)) {
            return ionTransitionGroup.get(ionTransition);
        }
        ionTransitionGroup.add(ionTransition);
        return ionTransition;
    }

    @Override
    public IIonTransition getIonTransition(double filter1Ion, double filter3Ion, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup) {
        return this.getIonTransition(filter1Ion, filter1Ion, filter3Ion, filter3Ion, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
    }

    @Override
    public IIonTransition getIonTransition(IIonTransition ionTransition, String compoundName) {
        if (ionTransition != null) {
            int transitionGroup = ionTransition.getTransitionGroup();
            IIonTransitionGroup ionTransitionGroup = this.ionTransitionGroups.get(transitionGroup);
            if (ionTransition.getCompoundName().equals(compoundName) && ionTransitionGroup.contains(ionTransition)) {
                return ionTransition;
            }
            IonTransition ionTransitionWithCompoundName = new IonTransition(ionTransition, compoundName);
            ionTransitionGroup.add(ionTransitionWithCompoundName);
            return ionTransitionWithCompoundName;
        }
        return ionTransition;
    }

    @Override
    public IIonTransitionGroup get(int index) {
        if (this.ionTransitionGroups.size() > index) {
            return this.ionTransitionGroups.get(index);
        }
        return null;
    }

    @Override
    public List<IIonTransitionGroup> getIonTransitionGroups() {
        return this.ionTransitionGroups;
    }

    @Override
    public Set<IIonTransition> getIonTransitions() {
        HashSet<IIonTransition> ionTransitions = new HashSet<IIonTransition>();
        for (IIonTransitionGroup ionTransitionGroup : this.ionTransitionGroups) {
            ionTransitions.addAll(ionTransitionGroup.getIonTransitions());
        }
        return ionTransitions;
    }

    @Override
    public int size() {
        return this.ionTransitionGroups.size();
    }
}

