/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.manual.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.manual.core.ManualPeakDetector;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.manual.ui.swt.PeakSelectionPaintListener;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.notifier.ChromatogramAndPeakSelectionUpdateNotifierCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramAndPeakSelectionUpdateNotifierMSD;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.AbstractViewChromatogramUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.Range;

public class ChromatogramSelectionUI
extends AbstractViewChromatogramUI {
    private static final Logger logger = Logger.getLogger(ChromatogramSelectionUI.class);
    private int xStart;
    private int yStart;
    private boolean isKeyPressed = false;
    private boolean isManualPeakSelection = false;
    private Cursor defaultCursor;
    private PeakSelectionPaintListener peakSelectionPaintListener;

    public ChromatogramSelectionUI(Composite parent, int style) {
        super(parent, style, (IAxisTitles)new AxisTitlesIntensityScale());
    }

    protected void initialize() {
        super.initialize();
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        this.peakSelectionPaintListener = new PeakSelectionPaintListener();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.peakSelectionPaintListener);
    }

    public void startDetectionMode() {
        this.isKeyPressed = true;
    }

    public void keyPressed(KeyEvent e) {
        if (!this.isKeyPressed && e.keyCode == 100) {
            this.isKeyPressed = true;
        } else {
            super.keyPressed(e);
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.isKeyPressed && e.button == 1) {
            this.startManualPeakSelection(e.x, e.y);
        } else {
            super.mouseDown(e);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.isManualPeakSelection && e.button == 1) {
            this.stopManualPeakSelection(e.x, e.y);
        } else {
            super.mouseUp(e);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.isManualPeakSelection) {
            this.trackManualPeakSelection(e.x, e.y);
        } else {
            super.mouseMove(e);
        }
    }

    public void setViewSeries() {
        ISeries series = SeriesConverter.convertChromatogram((IChromatogramSelection)this.getChromatogramSelection(), (Sign)Sign.POSITIVE, (boolean)true);
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.RED);
    }

    private void startManualPeakSelection(int x, int y) {
        this.xStart = x;
        this.yStart = y;
        this.defaultCursor = this.getPlotArea().getCursor();
        this.getPlotArea().setCursor(Display.getCurrent().getSystemCursor(2));
        this.isManualPeakSelection = true;
        this.peakSelectionPaintListener.setX1(this.xStart);
        this.peakSelectionPaintListener.setY1(this.yStart);
    }

    private void stopManualPeakSelection(int x, int y) {
        int xStop = x;
        int yStop = y;
        this.isKeyPressed = false;
        this.isManualPeakSelection = false;
        this.peakSelectionPaintListener.reset();
        this.getPlotArea().setCursor(this.defaultCursor);
        this.extractSelectedPeak(xStop, yStop);
    }

    private void extractSelectedPeak(int xStop, int yStop) {
        Rectangle rectangle = this.getPlotArea().getBounds();
        int height = rectangle.height;
        double factorHeight = 100.0 / (double)height;
        int width = rectangle.width;
        double factorWidth = 100.0 / (double)width;
        double percentageStartHeight = (100.0 - factorHeight * (double)this.yStart) / 100.0;
        double percentageStopHeight = (100.0 - factorHeight * (double)yStop) / 100.0;
        double percentageStartWidth = factorWidth * (double)this.xStart / 100.0;
        double percentageStopWidth = factorWidth * (double)xStop / 100.0;
        Range abundanceRange = this.getYAxisLeft().getRange();
        Range millisecondsRange = this.getXAxisTop().getRange();
        double abundanceHeight = abundanceRange.upper - abundanceRange.lower;
        double millisecondsWidth = millisecondsRange.upper - millisecondsRange.lower;
        int startRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStartWidth);
        int stopRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStopWidth);
        float startAbundance = (float)(abundanceRange.lower + abundanceHeight * percentageStartHeight);
        float stopAbundance = (float)(abundanceRange.lower + abundanceHeight * percentageStopHeight);
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD) {
            try {
                IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection;
                ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
                IChromatogramPeakMSD chromatogramPeak = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                ChromatogramAndPeakSelectionUpdateNotifierMSD.fireUpdateChange((IChromatogramSelectionMSD)chromatogramSelection, (IChromatogramPeakMSD)chromatogramPeak, (boolean)false);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        } else if (storedChromatogramSelection instanceof IChromatogramSelectionCSD) {
            try {
                IChromatogramSelectionCSD chromatogramSelection = (IChromatogramSelectionCSD)storedChromatogramSelection;
                ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                IChromatogramCSD chromatogram = chromatogramSelection.getChromatogramCSD();
                IChromatogramPeakCSD chromatogramPeak = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                ChromatogramAndPeakSelectionUpdateNotifierCSD.fireUpdateChange((IChromatogramSelectionCSD)chromatogramSelection, (IChromatogramPeakCSD)chromatogramPeak, (boolean)false);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
    }

    private void trackManualPeakSelection(int x, int y) {
        this.peakSelectionPaintListener.setX2(x);
        this.peakSelectionPaintListener.setY2(y);
        this.redraw();
    }
}

