/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.example;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SingularOps;

public class PrincipalComponentAnalysis {
    private DenseMatrix64F V_t;
    private int numComponents;
    private DenseMatrix64F A = new DenseMatrix64F(1, 1);
    private int sampleIndex;
    double[] mean;

    public void setup(int numSamples, int sampleSize) {
        this.mean = new double[sampleSize];
        this.A.reshape(numSamples, sampleSize, false);
        this.sampleIndex = 0;
        this.numComponents = -1;
    }

    public void addSample(double[] sampleData) {
        if (this.A.getNumCols() != sampleData.length) {
            throw new IllegalArgumentException("Unexpected sample size");
        }
        if (this.sampleIndex >= this.A.getNumRows()) {
            throw new IllegalArgumentException("Too many samples");
        }
        int i = 0;
        while (i < sampleData.length) {
            this.A.set(this.sampleIndex, i, sampleData[i]);
            ++i;
        }
        ++this.sampleIndex;
    }

    public void computeBasis(int numComponents) {
        int j;
        if (numComponents > this.A.getNumCols()) {
            throw new IllegalArgumentException("More components requested that the data's length.");
        }
        if (this.sampleIndex != this.A.getNumRows()) {
            throw new IllegalArgumentException("Not all the data has been added");
        }
        if (numComponents > this.sampleIndex) {
            throw new IllegalArgumentException("More data needed to compute the desired number of components");
        }
        this.numComponents = numComponents;
        int i = 0;
        while (i < this.A.getNumRows()) {
            j = 0;
            while (j < this.mean.length) {
                int n = j;
                this.mean[n] = this.mean[n] + this.A.get(i, j);
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < this.mean.length) {
            int n = j2++;
            this.mean[n] = this.mean[n] / (double)this.A.getNumRows();
        }
        i = 0;
        while (i < this.A.getNumRows()) {
            j = 0;
            while (j < this.mean.length) {
                this.A.set(i, j, this.A.get(i, j) - this.mean[j]);
                ++j;
            }
            ++i;
        }
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(this.A.numRows, this.A.numCols, false, true, false);
        if (!svd.decompose(this.A)) {
            throw new RuntimeException("SVD failed");
        }
        this.V_t = svd.getV(null, true);
        DenseMatrix64F W = svd.getW(null);
        SingularOps.descendingOrder(null, false, W, this.V_t, true);
        this.V_t.reshape(numComponents, this.mean.length, true);
    }

    public double[] getBasisVector(int which) {
        if (which < 0 || which >= this.numComponents) {
            throw new IllegalArgumentException("Invalid component");
        }
        DenseMatrix64F v = new DenseMatrix64F(1, this.A.numCols);
        CommonOps.extract(this.V_t, which, which + 1, 0, this.A.numCols, v, 0, 0);
        return v.data;
    }

    public double[] sampleToEigenSpace(double[] sampleData) {
        if (sampleData.length != this.A.getNumCols()) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F mean = DenseMatrix64F.wrap(this.A.getNumCols(), 1, this.mean);
        DenseMatrix64F s = new DenseMatrix64F(this.A.getNumCols(), 1, true, sampleData);
        DenseMatrix64F r = new DenseMatrix64F(this.numComponents, 1);
        CommonOps.subtract((D1Matrix64F)s, (D1Matrix64F)mean, (D1Matrix64F)s);
        CommonOps.mult(this.V_t, s, r);
        return r.data;
    }

    public double[] eigenToSampleSpace(double[] eigenData) {
        if (eigenData.length != this.numComponents) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F s = new DenseMatrix64F(this.A.getNumCols(), 1);
        DenseMatrix64F r = DenseMatrix64F.wrap(this.numComponents, 1, eigenData);
        CommonOps.multTransA(this.V_t, r, s);
        DenseMatrix64F mean = DenseMatrix64F.wrap(this.A.getNumCols(), 1, this.mean);
        CommonOps.add((D1Matrix64F)s, mean, (D1Matrix64F)s);
        return s.data;
    }

    public double errorMembership(double[] sampleA) {
        double[] eig = this.sampleToEigenSpace(sampleA);
        double[] reproj = this.eigenToSampleSpace(eig);
        double total = 0.0;
        int i = 0;
        while (i < reproj.length) {
            double d = sampleA[i] - reproj[i];
            total += d * d;
            ++i;
        }
        return Math.sqrt(total);
    }

    public double response(double[] sample) {
        if (sample.length != this.A.numCols) {
            throw new IllegalArgumentException("Expected input vector to be in sample space");
        }
        DenseMatrix64F dots = new DenseMatrix64F(this.numComponents, 1);
        DenseMatrix64F s = DenseMatrix64F.wrap(this.A.numCols, 1, sample);
        CommonOps.mult(this.V_t, s, dots);
        return NormOps.normF(dots);
    }
}

