/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.comparator.DefaultMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.ComparisonException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.NoMassSpectrumComparatorAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.internal.massspectrum.ComparatorCache;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparisonSupplier;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.purity.MassSpectrumPurityResult;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.IMassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.IMassSpectrumPurityProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.MassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.MassSpectrumPurityProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumComparisonResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class MassSpectrumComparator {
    private static final Logger logger = Logger.getLogger(MassSpectrumComparator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.comparison.massSpectrumComparisonSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String COMPARATOR_NAME = "comparatorName";
    private static final String MASS_SPECTRUM_COMPARATOR = "massSpectrumComparator";
    private static ComparatorCache comparatorCache = new ComparatorCache();
    private static IMassSpectrumComparatorProcessingInfo processingInfoComparisonSkip = new MassSpectrumComparatorProcessingInfo();
    private static final float NO_MATCH = 0.0f;

    static {
        processingInfoComparisonSkip.setMassSpectrumComparisonResult((IMassSpectrumComparisonResult)new MassSpectrumComparisonResult(0.0f, 0.0f, 0.0f, 0.0f));
    }

    private MassSpectrumComparator() {
    }

    public static IMassSpectrumComparatorProcessingInfo compare(IScanMSD unknown, IScanMSD reference, String comparatorId, boolean usePreOptimization, double thresholdPreOptimization) {
        return MassSpectrumComparator.compare(unknown, reference, MassSpectrumComparator.getMassSpectrumComparator(comparatorId), usePreOptimization, thresholdPreOptimization);
    }

    public static IMassSpectrumComparatorProcessingInfo compare(IScanMSD unknown, IScanMSD reference, IMassSpectrumComparator massSpectrumComparator, boolean usePreOptimization, double thresholdPreOptimization) {
        IMassSpectrumComparatorProcessingInfo processingInfo;
        boolean compare = true;
        if (usePreOptimization) {
            compare = comparatorCache.useReferenceForComparison(unknown, reference, thresholdPreOptimization);
        }
        if (compare) {
            if (massSpectrumComparator != null) {
                processingInfo = massSpectrumComparator.compare(unknown, reference);
            } else {
                massSpectrumComparator = new DefaultMassSpectrumComparator();
                processingInfo = massSpectrumComparator.compare(unknown, reference);
                processingInfo.addInfoMessage("MassSpectrum Comparator", "The requested comparator was not available. Instead the default comparator has been used.");
            }
        } else {
            processingInfo = processingInfoComparisonSkip;
        }
        return processingInfo;
    }

    public static IMassSpectrumPurityProcessingInfo getPurityResult(IScanMSD extractedMassSpectrum, IScanMSD genuineMassSpectrum) {
        MassSpectrumPurityProcessingInfo processingInfo = new MassSpectrumPurityProcessingInfo();
        try {
            MassSpectrumPurityResult massSpectrumPurityResult = new MassSpectrumPurityResult(extractedMassSpectrum, genuineMassSpectrum);
            processingInfo.setMassSpectrumPurityResult(massSpectrumPurityResult);
        }
        catch (ComparisonException e) {
            logger.warn((Object)e);
            processingInfo.addErrorMessage("MassSpectrum Purity", "The mass spectrum purity couldn't be calculated.");
        }
        return processingInfo;
    }

    public static String[][] getAvailableComparatorIds() {
        IMassSpectrumComparatorSupport massSpectrumComparatorSupport = MassSpectrumComparator.getMassSpectrumComparatorSupport();
        String[][] comparatorArray = null;
        try {
            List<String> comparatorIds = massSpectrumComparatorSupport.getAvailableComparatorIds();
            int size = comparatorIds.size();
            comparatorArray = new String[size][2];
            int i = 0;
            while (i < size) {
                String name;
                String converterId;
                try {
                    converterId = comparatorIds.get(i);
                    name = massSpectrumComparatorSupport.getMassSpectrumComparisonSupplier(converterId).getComparatorName();
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                    converterId = "";
                    name = "n.a.";
                }
                comparatorArray[i][0] = name;
                comparatorArray[i][1] = converterId;
                ++i;
            }
        }
        catch (NoMassSpectrumComparatorAvailableException e1) {
            logger.warn((Object)e1);
        }
        if (comparatorArray == null) {
            comparatorArray = new String[0][0];
        }
        return comparatorArray;
    }

    public static IMassSpectrumComparatorSupport getMassSpectrumComparatorSupport() {
        IConfigurationElement[] extensions;
        MassSpectrumComparatorSupport massSpectrumComparisonSupport = new MassSpectrumComparatorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MassSpectrumComparisonSupplier supplier = new MassSpectrumComparisonSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setComparatorName(element.getAttribute(COMPARATOR_NAME));
            massSpectrumComparisonSupport.add(supplier);
            ++n2;
        }
        return massSpectrumComparisonSupport;
    }

    public static IMassSpectrumComparator getMassSpectrumComparator(String comparatorId) {
        IConfigurationElement element = MassSpectrumComparator.getConfigurationElement(comparatorId);
        IMassSpectrumComparator instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumComparator)element.createExecutableExtension(MASS_SPECTRUM_COMPARATOR);
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

