/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IAreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.PeakIntegrationSettings;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.util.IonListUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_SELECTED_IONS = "selectedIons";
    public static final String DEF_SELECTED_IONS = "0";
    public static final String P_MINIMUM_PEAK_WIDTH = "minimumPeakWidth";
    public static final int DEF_MINIMUM_PEAK_WIDTH = 0;
    public static final String P_MINIMUM_SIGNAL_TO_NOISE_RATIO = "minimumSignalToNoiseRatio";
    public static final int DEF_MINIMUM_SIGNAL_TO_NOISE_RATIO = 0;
    public static final String P_MINIMUM_PEAK_AREA = "minimumPeakArea";
    public static final int DEF_MINIMUM_PEAK_AREA = 0;
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = 60000;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SELECTED_IONS, DEF_SELECTED_IONS);
        defaultValues.put(P_MINIMUM_PEAK_AREA, Integer.toString(0));
        defaultValues.put(P_MINIMUM_PEAK_WIDTH, Integer.toString(0));
        defaultValues.put(P_MINIMUM_SIGNAL_TO_NOISE_RATIO, Integer.toString(0));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static IPeakIntegrationSettings getPeakIntegrationSettings() {
        PeakIntegrationSettings integrationSettings = new PeakIntegrationSettings();
        IAreaSupport areaSupport = integrationSettings.getAreaSupport();
        areaSupport.setMinimumArea((double)PreferenceSupplier.getMinimumPeakArea());
        IIntegrationSupport integrationSupport = integrationSettings.getIntegrationSupport();
        integrationSupport.setMinimumPeakWidth(PreferenceSupplier.getMinimumPeakWidth());
        integrationSupport.setMinimumSignalToNoiseRatio((float)PreferenceSupplier.getMinimumSignalToNoiseRatio());
        IMarkedIons selectedIons = integrationSettings.getSelectedIons();
        Set<Integer> ions = PreferenceSupplier.getIons(P_SELECTED_IONS, DEF_SELECTED_IONS);
        PreferenceSupplier.setMarkedIons(selectedIons, ions);
        return integrationSettings;
    }

    public static int getMinimumPeakWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_PEAK_WIDTH, 0);
    }

    public static int getMinimumSignalToNoiseRatio() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_SIGNAL_TO_NOISE_RATIO, 0);
    }

    public static int getMinimumPeakArea() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_PEAK_AREA, 0);
    }

    public static void setMarkedIons(IMarkedIons markedIons, Set<Integer> ions) {
        for (int ion : ions) {
            markedIons.add((Object)new MarkedIon((double)ion));
        }
    }

    public static Set<Integer> getIons(String preference, String def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        IonListUtil ionListUtil = new IonListUtil();
        String preferenceEntry = preferences.get(preference, def);
        return ionListUtil.getIons(preferenceEntry);
    }
}

