/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider.WncResultsContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider.WncResultsLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider.WncResultsTableComparator;
import org.eclipse.chemclipse.model.core.IChromatogramResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class WncResultsView
extends AbstractChromatogramSelectionMSDView {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.views.wncResultsView.popup";
    @Inject
    private Composite parent;
    private ExtendedTableViewer tableViewer;
    private WncResultsTableComparator wncResultsTableComparator;
    private String[] titles = new String[]{"Name", "Ion", "Percentage Sum Intensity [%]", "Percentage Max Intensity [%]"};
    private int[] bounds = new int[]{100, 100, 100, 100};

    @Inject
    public WncResultsView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(this.parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new WncResultsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WncResultsLabelProvider());
        this.wncResultsTableComparator = new WncResultsTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.wncResultsTableComparator);
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    WncResultsView.this.tableViewer.copyToClipboard(WncResultsView.this.titles);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getControl().setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        IChromatogramResult chromatogramResult;
        Object result;
        IChromatogramResult object;
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection) && (object = chromatogramSelection.getChromatogram().getChromatogramResult("org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc")) instanceof IChromatogramResult && (result = (chromatogramResult = object).getResult()) instanceof IWncIons) {
            IWncIons wncIons = (IWncIons)result;
            this.update(wncIons, forceReload);
        }
    }

    public void update(IWncIons wncIons, boolean forceReload) {
        if (this.isPartVisible() && wncIons != null) {
            this.tableViewer.setInput((Object)wncIons);
        }
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        WncResultsView.this.tableViewer.copyToClipboard(WncResultsView.this.titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }
}

