/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramHeaderView {
    private static final Logger logger = Logger.getLogger(ChromatogramHeaderView.class);
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private Text text;
    private SimpleDateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    @Inject
    public ChromatogramHeaderView(Composite parent, IEventBroker eventBroker) {
        this.text = new Text(parent, 2818);
        if (eventBroker != null) {
            EventHandler eventHandlerFileOverview = new EventHandler(){

                public void handleEvent(Event event) {
                    try {
                        Object object = event.getProperty("org.eclipse.e4.data");
                        if (object instanceof File) {
                            ChromatogramHeaderView.this.setChromatogram((File)object);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
            };
            eventBroker.subscribe("chromatogram/msd/update/rawfile", eventHandlerFileOverview);
            EventHandler eventHandlerInstanceOverview = new EventHandler(){

                public void handleEvent(Event event) {
                    try {
                        Object object = event.getProperty("org.eclipse.e4.data");
                        if (object instanceof IChromatogramOverview) {
                            IChromatogramOverview chromatogramOverview = (IChromatogramOverview)object;
                            ChromatogramHeaderView.this.updateChromatogram(chromatogramOverview);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
            };
            eventBroker.subscribe("chromatogram/msd/update/overview", eventHandlerInstanceOverview);
        }
    }

    @Focus
    public void setFocus() {
        this.text.setFocus();
    }

    private void updateChromatogram(IChromatogramOverview chromatogramOverview) {
        if (this.partService.isPartVisible(this.part) && chromatogramOverview != null) {
            StringBuilder builder = new StringBuilder();
            this.addHeaderLine(builder, "Name", chromatogramOverview.getName());
            this.addHeaderLine(builder, "Data Name", chromatogramOverview.getDataName());
            this.addHeaderLine(builder, "Operator", chromatogramOverview.getOperator());
            Date date = chromatogramOverview.getDate();
            if (date != null) {
                this.addHeaderLine(builder, "Date", this.dateFormat.format(chromatogramOverview.getDate()));
            } else {
                this.addHeaderLine(builder, "Date", "");
            }
            this.addHeaderLine(builder, "Info", chromatogramOverview.getShortInfo());
            this.addHeaderLine(builder, "Misc", chromatogramOverview.getMiscInfo());
            this.addHeaderLine(builder, "Misc (separated)", chromatogramOverview.getMiscInfoSeparated());
            this.addHeaderLine(builder, "Details", chromatogramOverview.getDetailedInfo());
            this.addHeaderLine(builder, "Scans", Integer.toString(chromatogramOverview.getNumberOfScans()));
            this.addHeaderLine(builder, "Start RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStartRetentionTime() / 60000.0));
            this.addHeaderLine(builder, "Stop RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStopRetentionTime() / 60000.0));
            this.addHeaderLine(builder, "Barcode", chromatogramOverview.getBarcode());
            this.text.setText(builder.toString());
        }
    }

    private void addHeaderLine(StringBuilder builder, String key, String value) {
        builder.append(key);
        builder.append(": ");
        builder.append(value);
        builder.append("\n");
    }

    private void setChromatogram(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException {
        if (this.partService.isPartVisible(this.part)) {
            IChromatogramOverviewImportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convertOverview((File)file, (IProgressMonitor)new NullProgressMonitor());
            try {
                IChromatogramOverview chromatogramOverview = processingInfo.getChromatogramOverview();
                if (chromatogramOverview != null) {
                    this.updateChromatogram(chromatogramOverview);
                }
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }
}

