/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramOverviewImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramOverviewImportRunnable.class);
    private IChromatogramOverview chromatogramOverview;
    private File chromatogram;

    public ChromatogramOverviewImportRunnable(File chromatogram) {
        this.chromatogram = chromatogram;
    }

    public IChromatogramOverview getChromatogramOverview() {
        return this.chromatogramOverview;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Chromatogram Overview", -1);
                IChromatogramOverviewImportConverterProcessingInfo processingInfo = ChromatogramConverterMSD.convertOverview((File)this.chromatogram, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                this.chromatogramOverview = processingInfo.getChromatogramOverview();
            }
            catch (Exception e) {
                logger.warn((Object)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

