/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;

public class NestedProjectManager {
    private static NestedProjectManager INSTANCE = new NestedProjectManager();
    private Map<IPath, IProject> locationsToProjects = Collections.synchronizedMap(new TreeMap(new PathComparator()));
    private int knownProjectsCount;

    private NestedProjectManager() {
        this.refreshProjectsList();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1 && event.getDelta().getResource().getType() == 4) {
                    NestedProjectManager.this.refreshProjectsList();
                }
            }
        });
    }

    private void refreshProjectsListIfNeeded() {
        if (this.knownProjectsCount != ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            this.refreshProjectsList();
        }
    }

    private void refreshProjectsList() {
        this.locationsToProjects.clear();
        IProject[] knownProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.knownProjectsCount = knownProjects.length;
        IProject[] iProjectArray = knownProjects;
        int n = knownProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath location = project.getLocation();
            if (location != null) {
                this.locationsToProjects.put(location, project);
            }
            ++n2;
        }
    }

    public static NestedProjectManager getInstance() {
        return INSTANCE;
    }

    public IProject getProject(IFolder folder) {
        if (folder == null) {
            return null;
        }
        this.refreshProjectsListIfNeeded();
        IPath location = folder.getLocation();
        if (location == null) {
            return null;
        }
        IProject res = this.locationsToProjects.get(location);
        if (!(res == null || res.exists() && location.equals((Object)res.getLocation()))) {
            this.refreshProjectsList();
            return this.getProject(folder);
        }
        return res;
    }

    public boolean isShownAsProject(IFolder folder) {
        return this.getProject(folder) != null;
    }

    public boolean isShownAsNested(IProject project) {
        if (!project.exists()) {
            return false;
        }
        IPath location = project.getLocation();
        if (location == null) {
            return false;
        }
        IPath queriedLocation = location.removeLastSegments(1);
        while (queriedLocation.segmentCount() > 0) {
            if (this.locationsToProjects.containsKey(queriedLocation)) {
                return true;
            }
            queriedLocation = queriedLocation.removeLastSegments(1);
        }
        return false;
    }

    public IContainer getMostDirectOpenContainer(IProject project) {
        IPath location = project.getLocation();
        if (location == null) {
            return null;
        }
        IProject mostDirectParentProject = null;
        IPath queriedLocation = location.removeLastSegments(1);
        while (mostDirectParentProject == null && queriedLocation.segmentCount() > 0) {
            mostDirectParentProject = this.locationsToProjects.get(queriedLocation);
            if (mostDirectParentProject != null && mostDirectParentProject.getLocation() == null) {
                mostDirectParentProject = null;
            }
            queriedLocation = queriedLocation.removeLastSegments(1);
        }
        if (mostDirectParentProject != null) {
            IPath parentContainerAbsolutePath = location.removeLastSegments(1);
            IPath location2 = mostDirectParentProject.getLocation();
            if (location2 == null) {
                return null;
            }
            if (parentContainerAbsolutePath.equals((Object)location2)) {
                return mostDirectParentProject;
            }
            IPath parentFolderPathRelativeToProject = parentContainerAbsolutePath.removeFirstSegments(location2.segmentCount());
            return mostDirectParentProject.getFolder(parentFolderPathRelativeToProject);
        }
        return null;
    }
}

