/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.core;

import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.support.SumareaChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.AbstractChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.ChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramIntegrator
extends AbstractChromatogramIntegrator {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegrator.class);

    public IChromatogramIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IChromatogramIntegrationSettings chromatogramIntegrationSettings, IProgressMonitor monitor) {
        ChromatogramIntegratorProcessingInfo processingInfo = new ChromatogramIntegratorProcessingInfo();
        try {
            super.validate(chromatogramSelection, chromatogramIntegrationSettings);
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                SumareaChromatogramIntegratorSupport sumareaChromatogramIntegratorSupport = new SumareaChromatogramIntegratorSupport();
                IChromatogramIntegrationResults chromatogramIntegrationResults = sumareaChromatogramIntegratorSupport.calculateChromatogramIntegrationResults(chromatogramSelectionMSD, chromatogramIntegrationSettings, monitor);
                processingInfo.setChromatogramIntegrationResults(chromatogramIntegrationResults);
            } else {
                this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
            }
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IChromatogramIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramIntegrationSettings chromatogramIntegrationSettings = PreferenceSupplier.getIntegrationSettings();
        return this.integrate(chromatogramSelection, chromatogramIntegrationSettings, monitor);
    }

    private void addIntegratorExceptionInfo(IProcessingInfo processingInfo) {
        processingInfo.addErrorMessage("Sumarea Integrator", "The peak(s) or settings couldn't be validated correctly.");
    }
}

