/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.LibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.ILibraryServiceProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkaneIdentifier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.IRetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.PeakTableViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.PeakTargetsViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.LibraryMassSpectrumComparisonUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PagePeakAssignmentMSD
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PagePeakAssignmentMSD.class);
    private IRetentionIndexWizardElements wizardElements;
    private PeakTableViewerUI peakTableViewerUI;
    private LibraryMassSpectrumComparisonUI libraryMassSpectrumComparisonUI;
    private PeakTargetsViewerUI targetsViewerUI;
    private Button buttonPrevious;
    private Text textCurrentIndexName;
    private Button buttonNext;
    private String[] availableStandards;
    private int indexSelectedStandard;
    private String databaseName;
    private static final int ACTION_INCREASE_INDEX = 1;
    private static final int ACTION_DECREASE_INDEX = 2;

    public PagePeakAssignmentMSD(IRetentionIndexWizardElements wizardElements) {
        super(PagePeakAssignmentMSD.class.getName());
        this.setTitle("Peak Assigment");
        this.setDescription("Please assign the alkanes.");
        this.wizardElements = wizardElements;
        this.availableStandards = wizardElements.getAvailableStandards();
        File file = new File(AlkaneIdentifier.getDatabase());
        this.databaseName = file.getName();
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = this.wizardElements.getChromatogramSelectionMSD();
            if (chromatogramSelectionMSD != null && chromatogramSelectionMSD.getChromatogramMSD() != null) {
                this.indexSelectedStandard = this.getStartIndex(this.availableStandards, this.wizardElements.getStartIndexName());
                if (this.indexSelectedStandard > -1) {
                    this.textCurrentIndexName.setText(this.availableStandards[this.indexSelectedStandard]);
                } else {
                    this.textCurrentIndexName.setText("");
                }
                IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
                List peaks = chromatogramMSD.getPeaks();
                this.peakTableViewerUI.setInput(peaks);
                this.peakTableViewerUI.getTable().setSelection(0);
                if (peaks.size() > 0) {
                    IChromatogramPeakMSD peak = (IChromatogramPeakMSD)peaks.get(0);
                    List targets = peak.getTargets();
                    this.targetsViewerUI.setInput(targets);
                    this.targetsViewerUI.getTable().setSelection(0);
                    this.showLibraryMassSpectrum();
                }
            } else {
                this.peakTableViewerUI.setInput(null);
                this.textCurrentIndexName.setText("");
            }
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createAutoAssignField(composite);
        this.createPeakTableField(composite);
        this.createLibraryComparisonField(composite);
        this.createTargetSpinnerField(composite);
        this.createAssignIndexField(composite);
        this.createPeakTargetsField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createAutoAssignField(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText("Auto Assign Standards");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IChromatogramSelectionMSD chromatogramSelectionMSD;
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setText("Auto assign standards");
                messageBox.setMessage("Would you like to set all standards automatically?");
                if (messageBox.open() == 64 && (chromatogramSelectionMSD = PagePeakAssignmentMSD.this.wizardElements.getChromatogramSelectionMSD()) != null && chromatogramSelectionMSD.getChromatogramMSD() != null) {
                    IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
                    List chromatogramPeaks = chromatogramMSD.getPeaks();
                    List<IRetentionIndexEntry> retentionIndexEntries = PagePeakAssignmentMSD.this.wizardElements.getSelectedRetentionIndexEntries();
                    if (chromatogramPeaks.size() == retentionIndexEntries.size()) {
                        int i = 0;
                        while (i < chromatogramPeaks.size()) {
                            IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)chromatogramPeaks.get(i);
                            IRetentionIndexEntry retentionIndexEntry = retentionIndexEntries.get(i);
                            PagePeakAssignmentMSD.this.setPeakTarget(chromatogramPeak, retentionIndexEntry.getName(), true);
                            ++i;
                        }
                        PagePeakAssignmentMSD.this.peakTableViewerUI.getTable().setSelection(0);
                        chromatogramSelectionMSD.reset();
                        IChromatogramPeakMSD selectedPeak = PagePeakAssignmentMSD.this.getSelectedPeak();
                        if (selectedPeak != null) {
                            PagePeakAssignmentMSD.this.targetsViewerUI.setInput(selectedPeak.getTargets());
                            PagePeakAssignmentMSD.this.targetsViewerUI.getTable().setSelection(0);
                            PagePeakAssignmentMSD.this.showLibraryMassSpectrum();
                        }
                    } else {
                        String message = "The number of peaks (" + chromatogramPeaks.size() + ") and selected standards (" + retentionIndexEntries.size() + ") is unequal.";
                        PagePeakAssignmentMSD.this.updateStatus(message);
                    }
                }
            }
        });
    }

    private void createPeakTableField(Composite composite) {
        this.peakTableViewerUI = new PeakTableViewerUI(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.peakTableViewerUI.getTable().setLayoutData((Object)gridData);
        this.peakTableViewerUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IChromatogramPeakMSD selectedPeak = PagePeakAssignmentMSD.this.getSelectedPeak();
                if (selectedPeak != null) {
                    PagePeakAssignmentMSD.this.targetsViewerUI.setInput(selectedPeak.getTargets());
                    PagePeakAssignmentMSD.this.targetsViewerUI.getTable().setSelection(0);
                    PagePeakAssignmentMSD.this.showLibraryMassSpectrum();
                }
            }
        });
    }

    private void createLibraryComparisonField(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        parent.setLayoutData((Object)gridData);
        parent.setLayout((Layout)new FillLayout());
        this.libraryMassSpectrumComparisonUI = new LibraryMassSpectrumComparisonUI(parent, 0, MassValueDisplayPrecision.NOMINAL);
    }

    private void createTargetSpinnerField(Composite composite) {
        this.buttonPrevious = new Button(composite, 8);
        this.buttonPrevious.setImage(ApplicationImageFactory.getInstance().getImage("previous.gif", "16x16"));
        this.buttonPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignmentMSD.this.setCurrentIndexName(2);
            }
        });
        this.textCurrentIndexName = new Text(composite, 2048);
        this.textCurrentIndexName.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textCurrentIndexName.setLayoutData((Object)gridData);
        this.buttonNext = new Button(composite, 8);
        this.buttonNext.setImage(ApplicationImageFactory.getInstance().getImage("next.gif", "16x16"));
        this.buttonNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagePeakAssignmentMSD.this.setCurrentIndexName(1);
            }
        });
    }

    private void createAssignIndexField(Composite composite) {
        Button buttonAdd = new Button(composite, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        buttonAdd.setLayoutData((Object)gridData);
        buttonAdd.setText("Replace peak targets by selected index");
        buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("execute_add.gif", "16x16"));
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IChromatogramPeakMSD selectedPeak = PagePeakAssignmentMSD.this.getSelectedPeak();
                if (selectedPeak != null) {
                    String name = PagePeakAssignmentMSD.this.textCurrentIndexName.getText().trim();
                    PagePeakAssignmentMSD.this.setPeakTarget(selectedPeak, name, true);
                }
            }
        });
    }

    private void setPeakTarget(IChromatogramPeakMSD chromatogramPeak, String name, boolean deleteOtherTargets) {
        if (deleteOtherTargets) {
            chromatogramPeak.removeAllTargets();
        }
        try {
            float FACTOR = 100.0f;
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setName(name);
            libraryInformation.setDatabase(this.databaseName);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(FACTOR, FACTOR, FACTOR, FACTOR, FACTOR);
            PeakTarget peakTarget = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
            peakTarget.setIdentifier("Alkane Identifier");
            chromatogramPeak.addTarget((IPeakTarget)peakTarget);
            this.targetsViewerUI.setInput(chromatogramPeak.getTargets());
            this.setCurrentIndexName(1);
        }
        catch (ReferenceMustNotBeNullException e1) {
            logger.warn((Object)e1);
        }
    }

    private void createPeakTargetsField(Composite composite) {
        this.targetsViewerUI = new PeakTargetsViewerUI(composite, 2050);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.targetsViewerUI.getTable().setLayoutData((Object)gridData);
        this.targetsViewerUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PagePeakAssignmentMSD.this.showLibraryMassSpectrum();
            }
        });
        this.targetsViewerUI.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    IChromatogramPeakMSD chromatogramPeakMSD;
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    messageBox.setText("Delete identification(s)");
                    messageBox.setMessage("Would you like to delete the identification(s)?");
                    if (messageBox.open() == 64 && (chromatogramPeakMSD = PagePeakAssignmentMSD.this.getSelectedPeak()) != null) {
                        Table table = PagePeakAssignmentMSD.this.targetsViewerUI.getTable();
                        int[] indices = table.getSelectionIndices();
                        List targetsToRemove = PagePeakAssignmentMSD.this.getPeakTargetList(table, indices);
                        chromatogramPeakMSD.removeTargets(targetsToRemove);
                        PagePeakAssignmentMSD.this.targetsViewerUI.setInput(chromatogramPeakMSD.getTargets());
                        PagePeakAssignmentMSD.this.validateSelection();
                    }
                }
            }
        });
    }

    private IChromatogramPeakMSD getSelectedPeak() {
        Table table = this.peakTableViewerUI.getTable();
        int index = table.getSelectionIndex();
        Object object = this.peakTableViewerUI.getElementAt(index);
        if (object instanceof IChromatogramPeakMSD) {
            return (IChromatogramPeakMSD)object;
        }
        return null;
    }

    private IPeakTarget getSelectedTarget() {
        Table table = this.targetsViewerUI.getTable();
        int index = table.getSelectionIndex();
        Object object = this.targetsViewerUI.getElementAt(index);
        if (object instanceof IPeakTarget) {
            return (IPeakTarget)object;
        }
        return null;
    }

    private int getStartIndex(String[] availableStandards, String startIndexName) {
        int i = 0;
        while (i < availableStandards.length) {
            if (availableStandards[i].equals(startIndexName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setCurrentIndexName(int action) {
        switch (action) {
            case 1: {
                this.buttonPrevious.setEnabled(true);
                ++this.indexSelectedStandard;
                if (this.indexSelectedStandard < this.availableStandards.length) break;
                this.indexSelectedStandard = this.availableStandards.length - 1;
                this.buttonNext.setEnabled(false);
                break;
            }
            case 2: {
                this.buttonNext.setEnabled(true);
                --this.indexSelectedStandard;
                if (this.indexSelectedStandard >= 0) break;
                this.indexSelectedStandard = 0;
                this.buttonPrevious.setEnabled(false);
            }
        }
        this.textCurrentIndexName.setText(this.availableStandards[this.indexSelectedStandard]);
    }

    private void showLibraryMassSpectrum() {
        IChromatogramPeakMSD selectedPeak;
        IPeakTarget peakTarget = this.getSelectedTarget();
        if (peakTarget != null && (selectedPeak = this.getSelectedPeak()) != null) {
            ILibraryServiceProcessingInfo processingInfo = LibraryService.identify((IIdentificationTarget)peakTarget, (IProgressMonitor)new NullProgressMonitor());
            try {
                IMassSpectra massSpectra = processingInfo.getMassSpectra();
                if (massSpectra.size() > 0) {
                    IPeakMassSpectrum unknownMassSpectrum = selectedPeak.getPeakModel().getPeakMassSpectrum();
                    IScanMSD libraryMassSpectrum = massSpectra.getMassSpectrum(1);
                    this.libraryMassSpectrumComparisonUI.update((IScanMSD)unknownMassSpectrum, libraryMassSpectrum, true);
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
    }

    private List<IPeakTarget> getPeakTargetList(Table table, int[] indices) {
        ArrayList<IPeakTarget> targetList = new ArrayList<IPeakTarget>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IPeakTarget) {
                IPeakTarget target = (IPeakTarget)object;
                targetList.add(target);
            }
            ++n2;
        }
        return targetList;
    }

    private void validateSelection() {
        String message = null;
        this.updateStatus(message);
    }
}

