/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.filter.core.peak;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.filter.core.peak.IPeakFilter;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractPeakFilter
implements IPeakFilter {
    private static final String DESCRIPTION = "Peak Filter";

    @Override
    public IProcessingInfo validate(IPeakCSD peak, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validatePeak(peak));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(List<IPeakCSD> peaks, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validatePeaks(peaks));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(IChromatogramSelectionCSD chromatogramSelection, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateChromatogramSelection(chromatogramSelection));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    private IProcessingInfo validatePeak(IPeakCSD peak) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peak == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The peak is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validatePeaks(List<IPeakCSD> peaks) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peaks == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The peak list is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateFilterSettings(IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peakFilterSettings == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings are not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateChromatogramSelection(IChromatogramSelectionCSD chromatogramSelection) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram selection is not valid.");
        } else if (chromatogramSelection.getChromatogram() == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram is not valid.");
        }
        return processingInfo;
    }
}

