/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoChromatogramFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.IChromatogramFilterSupplierMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.IChromatogramFilterSupportMSD;

public class ChromatogramFilterSupportMSD
implements IChromatogramFilterSupportMSD {
    private List<IChromatogramFilterSupplierMSD> suppliers = new ArrayList<IChromatogramFilterSupplierMSD>();

    protected void add(IChromatogramFilterSupplierMSD supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableFilterIds() throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        ArrayList<String> availableFilters = new ArrayList<String>();
        for (IChromatogramFilterSupplierMSD supplier : this.suppliers) {
            availableFilters.add(supplier.getId());
        }
        return availableFilters;
    }

    @Override
    public String getFilterId(int index) throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter available with the following id: " + index + ".");
        }
        IChromatogramFilterSupplierMSD supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getFilterNames() throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IChromatogramFilterSupplierMSD supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public IChromatogramFilterSupplierMSD getFilterSupplier(String filterId) throws NoChromatogramFilterSupplierAvailableException {
        IChromatogramFilterSupplierMSD filterSupplier = null;
        this.areChromatogramFiltersStored();
        if (filterId == null || filterId.equals("")) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter supplier available with the following id: " + filterId + ".");
        }
        for (IChromatogramFilterSupplierMSD supplier : this.suppliers) {
            if (!supplier.getId().equals(filterId)) continue;
            filterSupplier = supplier;
            break;
        }
        if (filterSupplier == null) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter supplier available with the following id: " + filterId + ".");
        }
        return filterSupplier;
    }

    private void areChromatogramFiltersStored() throws NoChromatogramFilterSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoChromatogramFilterSupplierAvailableException();
        }
    }
}

