/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabaseProxy;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabases;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationTableAlreadyExistsException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.DatabaseTableComparator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.DatabasesContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.DatabasesLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.AbstractTableViewerUI;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.DatabaseNameDialog;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatabasesUI
extends AbstractTableViewerUI {
    private static final Logger logger = Logger.getLogger(DatabasesUI.class);
    private static final String MESSAGE_BOX_TEXT = "Quantitation Tables";
    private IEventBroker eventBroker;

    public DatabasesUI(Composite parent, int style, IEventBroker eventBroker) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.addList(composite);
        this.addButtons(composite);
        this.eventBroker = eventBroker;
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.setTableViewerInput();
    }

    private void addList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataTable = new GridData(1808);
        gridDataTable.grabExcessHorizontalSpace = true;
        gridDataTable.grabExcessVerticalSpace = true;
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)gridDataTable);
        String[] titles = new String[]{"Quantitation Table", "Path"};
        int[] bounds = new int[]{100, 100};
        DatabasesContentProvider contentProvider = new DatabasesContentProvider();
        DatabasesLabelProvider labelProvider = new DatabasesLabelProvider();
        DatabaseTableComparator viewerTableComparator = new DatabaseTableComparator();
        this.createTableViewer(composite, gridDataTable, contentProvider, labelProvider, viewerTableComparator, titles, bounds);
        this.getTableViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IQuantDatabaseProxy databaseProxy = DatabasesUI.this.getSelectedDatabaseProxy();
                if (databaseProxy != null) {
                    DatabasesUI.this.setDatabase(databaseProxy.getDatabaseName());
                    DatabasesUI.this.showMessage(DatabasesUI.MESSAGE_BOX_TEXT, "The quantitation table has been selected successfully: " + databaseProxy.getDatabaseName());
                }
            }
        });
        this.setTableViewerInput();
    }

    private void setTableViewerInput() {
        try {
            this.getTableViewer().setInput((Object)QuantDatabases.listAvailableDatabaseProxies());
        }
        catch (NoQuantitationTableAvailableException e) {
            logger.warn((Object)e);
        }
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataButtons = new GridData(1040);
        gridDataButtons.verticalAlignment = 128;
        composite.setLayoutData((Object)gridDataButtons);
        this.addButtonSelect(composite);
        this.addButtonNew(composite);
        this.addButtonRemove(composite);
        this.addButtonSave(composite);
    }

    private void addButtonSelect(Composite parent) {
        Button buttonSelectDatabase = new Button(parent, 8);
        buttonSelectDatabase.setLayoutData((Object)new GridData(768));
        buttonSelectDatabase.setText("Select");
        buttonSelectDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IQuantDatabaseProxy databaseProxy = DatabasesUI.this.getSelectedDatabaseProxy();
                if (databaseProxy != null) {
                    DatabasesUI.this.setDatabase(databaseProxy.getDatabaseName());
                    DatabasesUI.this.showMessage(DatabasesUI.MESSAGE_BOX_TEXT, "The quantitation table has been selected successfully: " + databaseProxy.getDatabaseName());
                }
            }
        });
    }

    private void addButtonNew(Composite parent) {
        Button buttonNewDatabase = new Button(parent, 8);
        buttonNewDatabase.setLayoutData((Object)new GridData(768));
        buttonNewDatabase.setText("New");
        buttonNewDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                DatabaseNameDialog databaseNameDialog = new DatabaseNameDialog(shell);
                databaseNameDialog.create();
                if (databaseNameDialog.open() == 0) {
                    try {
                        QuantDatabases.createDatabase((String)databaseNameDialog.getDatabaseName().trim());
                        DatabasesUI.this.setTableViewerInput();
                    }
                    catch (QuantitationTableAlreadyExistsException e1) {
                        DatabasesUI.this.showMessage("Quantitation Table", "The database already exists.");
                        logger.warn((Object)e1);
                    }
                }
            }
        });
    }

    private void addButtonRemove(Composite parent) {
        Button buttonDeleteDatabase = new Button(parent, 8);
        buttonDeleteDatabase.setLayoutData((Object)new GridData(768));
        buttonDeleteDatabase.setText("Delete");
        buttonDeleteDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabasesUI.this.showMessage("Quantitation Table", "Please delete the database manually under the given path.");
            }
        });
    }

    private void addButtonSave(Composite parent) {
        Button buttonSaveDatabases = new Button(parent, 8);
        buttonSaveDatabases.setLayoutData((Object)new GridData(768));
        buttonSaveDatabases.setText("Save");
        buttonSaveDatabases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantDatabases.persistDatabases();
            }
        });
    }

    private void setDatabase(String databaseName) {
        PreferenceSupplier.setSelectedQuantitationTable((String)databaseName);
        if (this.eventBroker != null) {
            this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationtable", (Object)PreferenceSupplier.getSelectedQuantitationTable());
        }
    }

    private IQuantDatabaseProxy getSelectedDatabaseProxy() {
        IStructuredSelection structuredSelection;
        Object object;
        ISelection selection = this.getTableViewer().getSelection();
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IQuantDatabaseProxy) {
            return (IQuantDatabaseProxy)object;
        }
        return null;
    }
}

