/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConcentrationResponseLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IConcentrationResponseEntryMSD) {
            IConcentrationResponseEntryMSD entry = (IConcentrationResponseEntryMSD)element;
            switch (columnIndex) {
                case 0: {
                    double ion = entry.getIon();
                    if (ion == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(ion);
                    break;
                }
                case 1: {
                    text = decimalFormat.format(entry.getConcentration());
                    break;
                }
                case 2: {
                    text = decimalFormat.format(entry.getResponse());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("quantifySelectedPeak.gif", "16x16");
    }
}

