/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class MassSpectrumPeakLabelProvider
extends AbstractChemClipseLabelProvider {
    public MassSpectrumPeakLabelProvider() {
        super("0.0##");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            IIonTransition ionTransition = ion.getIonTransition();
            switch (columnIndex) {
                case 0: {
                    String mz = decimalFormat.format(ion.getIon());
                    text = ionTransition == null ? mz : String.valueOf(Integer.toString((int)ionTransition.getQ1StartIon())) + " > " + mz;
                    break;
                }
                case 1: {
                    text = decimalFormat.format(ion.getAbundance());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("ion.gif", "16x16");
    }
}

