/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.ux.extension.ui.provider.AbstractChromatogramIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramEditorSupport;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public abstract class AbstractChromatogramEditorSupport
extends AbstractChromatogramIdentifier
implements IChromatogramEditorSupport {
    protected EModelService modelService;
    protected MApplication application;
    protected EPartService partService;

    public AbstractChromatogramEditorSupport(List<ISupplier> suppliers) {
        super(suppliers);
    }

    public void openEditor(File file, IChromatogram chromatogram, String elementId, String contributionURI, String iconURI, String tooltip) {
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.application.getContext().set("activeChildContext", (Object)window.getContext());
        MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
        MInputPart part = MBasicFactory.INSTANCE.createInputPart();
        part.setElementId(elementId);
        part.setContributionURI(contributionURI);
        if (file == null) {
            if (chromatogram != null) {
                part.setObject((Object)chromatogram);
                part.setLabel(chromatogram.getName());
            } else {
                part.setObject(null);
                part.setLabel("No valid chromatogram");
            }
        } else {
            part.setObject((Object)file.getAbsolutePath());
            part.setLabel(file.getName());
        }
        part.setIconURI(iconURI);
        part.setTooltip(tooltip);
        part.setCloseable(true);
        partStack.getChildren().add(part);
        this.partService.showPart((MPart)part, EPartService.PartState.ACTIVATE);
    }
}

