/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ChromatogramSelectionWizardPage
extends WizardPage {
    private Table inputFilesTable;
    private Label countFiles;
    private static final String FILES = "Input Files: ";

    public ChromatogramSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.createChromatogramReportExportFileSelection(container, layoutData);
        this.setControl((Control)container);
    }

    public Table getTable() {
        return this.inputFilesTable;
    }

    private void createChromatogramReportExportFileSelection(Composite parent, GridData layoutData) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)layoutData);
        this.createTable(client);
        this.createButtons(client);
        this.createLabels(client);
    }

    private void createTable(Composite parent) {
        this.inputFilesTable = new Table(parent, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 3;
        this.inputFilesTable.setLayoutData((Object)gridData);
        this.inputFilesTable.setHeaderVisible(true);
        this.inputFilesTable.setLinesVisible(true);
        String[] titles = new String[]{"Filename", "Path"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.inputFilesTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            this.inputFilesTable.getColumn(i).pack();
            ++i;
        }
    }

    private void createButtons(Composite parent) {
        this.createAddButton(parent);
        this.createRemoveButton(parent);
        this.createRemoveAllButton(parent);
    }

    private void createAddButton(Composite parent) {
        Button add = new Button(parent, 8);
        add.setText("Add");
        add.setLayoutData((Object)new GridData(258));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                List ocbFiles = ChromatogramSelectionWizardPage.this.getChromatogramFileSelection();
                TableItem[] items = ChromatogramSelectionWizardPage.this.inputFilesTable.getItems();
                for (String ocbFile : ocbFiles) {
                    File file = new File(ocbFile);
                    if (!ChromatogramSelectionWizardPage.this.addItem(items, file)) continue;
                    TableItem item = new TableItem(ChromatogramSelectionWizardPage.this.inputFilesTable, 0);
                    item.setText(0, file.getName());
                    item.setText(1, file.getAbsolutePath());
                }
                ChromatogramSelectionWizardPage.this.updateCountFileLabel();
            }
        });
    }

    private boolean addItem(TableItem[] items, File file) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(file.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void createRemoveButton(Composite parent) {
        Button remove = new Button(parent, 8);
        remove.setText("Remove");
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ChromatogramSelectionWizardPage.this.removeEntries(ChromatogramSelectionWizardPage.this.inputFilesTable.getSelectionIndices());
            }
        });
    }

    private void createRemoveAllButton(Composite parent) {
        Button remove = new Button(parent, 8);
        remove.setText("Remove All");
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ChromatogramSelectionWizardPage.this.inputFilesTable.removeAll();
                ChromatogramSelectionWizardPage.this.updateCountFileLabel();
            }
        });
    }

    private void createLabels(Composite parent) {
        this.countFiles = new Label(parent, 0);
        this.countFiles.setLayoutData((Object)new GridData(256));
        this.updateCountFileLabel();
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.inputFilesTable.remove(indices);
        this.updateCountFileLabel();
    }

    private void updateCountFileLabel() {
        int count = this.inputFilesTable.getItemCount();
        this.countFiles.setText(FILES + count);
        if (count > 0) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("Please select chromatograms that shall be used for reporting.");
            this.setPageComplete(false);
        }
    }

    private List<String> getChromatogramFileSelection() {
        ArrayList<String> selectedFiles = new ArrayList<String>();
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 4098);
        fileDialog.setText("Please select the chromatograms used for reporting.");
        fileDialog.setFilterExtensions(new String[]{"*.ocb"});
        fileDialog.setFilterNames(new String[]{"OpenChrom Chromatogram (*.ocb)"});
        String value = fileDialog.open();
        if (value != null) {
            String[] fileNames;
            String directory = fileDialog.getFilterPath();
            if (!directory.endsWith(File.separator)) {
                directory = String.valueOf(directory) + File.separator;
            }
            String[] stringArray = fileNames = fileDialog.getFileNames();
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                selectedFiles.add(String.valueOf(directory) + fileName);
                ++n2;
            }
        }
        return selectedFiles;
    }
}

