/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.exceptions.NoIdentifiedScansAvailableException;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;

public class SeriesConverterCSD {
    private SeriesConverterCSD() {
    }

    public static ISeries convertPeak(IPeakCSD peak, boolean includeBackground, Sign sign) {
        ArrayList<IPeakCSD> peaks = new ArrayList<IPeakCSD>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverterCSD.convertPeak(peaks, includeBackground, sign, (IOffset)offset);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertPeakMaxPositions(IChromatogramSelectionCSD chromatogramSelection, IOffset offset, Sign sign, boolean activeForAnalysis) throws NoPeaksAvailableException {
        List peaks = chromatogramSelection.getChromatogramCSD().getPeaks(chromatogramSelection);
        IMultipleSeries peakSeries = SeriesConverter.convertPeakMaxMarker((List)peaks, (Sign)sign, (IOffset)offset, (boolean)activeForAnalysis);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertSelectedPeak(IPeakCSD peak, boolean includeBackground, Sign sign) {
        ArrayList<IPeakCSD> peaks = new ArrayList<IPeakCSD>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverterCSD.convertPeak(peaks, includeBackground, sign, (IOffset)offset);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertSelectedPeakBackground(IPeakCSD peak, Sign sign) {
        ArrayList<IPeakCSD> peaks = new ArrayList<IPeakCSD>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverterCSD.convertPeakBackground(peaks, sign, (IOffset)offset);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static IMultipleSeries convertPeak(List<IPeakCSD> peaks, boolean includeBackground, Sign sign, IOffset offset) {
        MultipleSeries peakSeries = new MultipleSeries();
        if (peaks != null) {
            offset = SeriesConverter.validateOffset((IOffset)offset);
            for (IPeakCSD peak : peaks) {
                if (peak == null) continue;
                IPeakModelCSD peakModel = peak.getPeakModel();
                int size = peakModel.getRetentionTimes().size();
                double[] xSeries = new double[size];
                double[] ySeries = new double[size];
                int x = 0;
                int y = 0;
                Iterator iterator = peakModel.getRetentionTimes().iterator();
                while (iterator.hasNext()) {
                    int retentionTime = (Integer)iterator.next();
                    double abundance = peakModel.getPeakAbundance(retentionTime);
                    if (includeBackground) {
                        abundance += (double)peakModel.getBackgroundAbundance(retentionTime);
                    }
                    double xOffset = offset.getCurrentXOffset();
                    double yOffset = offset.getCurrentYOffset();
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    retentionTime = (int)((double)retentionTime + xOffset);
                    xSeries[x++] = retentionTime;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                peakSeries.add((ISeries)new Series(xSeries, ySeries, "Peak"));
            }
        }
        return peakSeries;
    }

    public static ISeries convertIdentifiedScans(IChromatogramSelectionCSD chromatogramSelection, IOffset offset, Sign sign) throws NoIdentifiedScansAvailableException {
        IMultipleSeries identifiedScansSeries = SeriesConverterCSD.convertIdentifiedScans(chromatogramSelection, sign, offset);
        return (ISeries)identifiedScansSeries.getMultipleSeries().get(0);
    }

    public static List<IScanCSD> getIdentifiedScans(IChromatogramSelectionCSD chromatogramSelection, boolean enforceLoadScanProxy) {
        ArrayList<IScanCSD> identifiedScans = new ArrayList<IScanCSD>();
        List scans = chromatogramSelection.getChromatogram().getScans();
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        for (IScan scan : scans) {
            int retentionTime;
            IScanCSD scanCSD;
            if (!(scan instanceof IScanCSD) || (scanCSD = (IScanCSD)scan).getTargets().size() <= 0 || (retentionTime = scanCSD.getRetentionTime()) < startRetentionTime || retentionTime > stopRetentionTime) continue;
            identifiedScans.add(scanCSD);
        }
        return identifiedScans;
    }

    private static IMultipleSeries convertIdentifiedScans(IChromatogramSelectionCSD chromatogramSelection, Sign sign, IOffset offset) throws NoIdentifiedScansAvailableException {
        MultipleSeries identifiedScanSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            offset = SeriesConverter.validateOffset((IOffset)offset);
            List<IScanCSD> identifiedScans = SeriesConverterCSD.getIdentifiedScans(chromatogramSelection, false);
            int amountIdentifiedScans = identifiedScans.size();
            if (amountIdentifiedScans == 0) {
                throw new NoIdentifiedScansAvailableException();
            }
            double[] xSeries = new double[amountIdentifiedScans];
            double[] ySeries = new double[amountIdentifiedScans];
            int x = 0;
            int y = 0;
            for (IScanCSD identifiedScan : identifiedScans) {
                double retentionTime = identifiedScan.getRetentionTime();
                double abundance = identifiedScan.getTotalSignal();
                double xOffset = offset.getCurrentXOffset();
                double yOffset = offset.getCurrentYOffset();
                if (sign == Sign.NEGATIVE) {
                    abundance *= -1.0;
                    xOffset *= -1.0;
                    yOffset *= -1.0;
                }
                xSeries[x++] = retentionTime += xOffset;
                ySeries[y++] = abundance += yOffset;
                identifiedScanSeries.add((ISeries)new Series(xSeries, ySeries, "Identified Scans"));
            }
        }
        return identifiedScanSeries;
    }

    public static ISeries convertPeakBackground(IPeakCSD peak, Sign sign) {
        ArrayList<IPeakCSD> peaks = new ArrayList<IPeakCSD>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverterCSD.convertPeakBackground(peaks, sign, (IOffset)offset);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static IMultipleSeries convertPeakBackground(List<IPeakCSD> peaks, Sign sign, IOffset offset) {
        MultipleSeries peakBackgroundSeries = new MultipleSeries();
        if (peaks != null) {
            offset = SeriesConverter.validateOffset((IOffset)offset);
            for (IPeakCSD peak : peaks) {
                if (peak == null) continue;
                IPeakModelCSD peakModel = peak.getPeakModel();
                int size = peakModel.getRetentionTimes().size();
                double[] xSeries = new double[size];
                double[] ySeries = new double[size];
                int x = 0;
                int y = 0;
                Iterator iterator = peakModel.getRetentionTimes().iterator();
                while (iterator.hasNext()) {
                    int retentionTime = (Integer)iterator.next();
                    double abundance = peakModel.getBackgroundAbundance(retentionTime);
                    double xOffset = offset.getCurrentXOffset();
                    double yOffset = offset.getCurrentYOffset();
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    retentionTime = (int)((double)retentionTime + xOffset);
                    xSeries[x++] = retentionTime;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                peakBackgroundSeries.add((ISeries)new Series(xSeries, ySeries, "Background"));
            }
        }
        return peakBackgroundSeries;
    }

    public static ISeries convertIncreasingInflectionPoints(IPeakCSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelCSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            try {
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)baseline);
                double startRetentionTime = peakModel.getStartRetentionTime();
                double x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                xSeries[0] = intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Increasing Tangent");
        }
        return series;
    }

    public static ISeries convertDecreasingInflectionPoints(IPeakCSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelCSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            try {
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)decreasing, (LinearEquation)baseline);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                double x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[0] = intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double startRetentionTime = peakModel.getStartRetentionTime();
                x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Decreasing Tangent");
        }
        return series;
    }

    public static ISeries convertPeakPerpendicular(IPeakCSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelCSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            xSeries[0] = peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints();
            ySeries[0] = includeBackground ? (double)peakModel.getBackgroundAbundance(peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints()) : 0.0;
            try {
                IPoint intersection = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)peakModel.getDecreasingInflectionPointEquation());
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)intersection.getX()) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Peak Perpendicular");
        }
        return series;
    }

    public static ISeries convertPeakWidthByInflectionPoints(IPeakCSD peak, boolean includeBackground, float height, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelCSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            LinearEquation percentageHeightBaseline = peakModel.getPercentageHeightBaselineEquation(height);
            if (percentageHeightBaseline != null) {
                try {
                    IPoint p1 = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    IPoint p2 = Equations.calculateIntersection((LinearEquation)peakModel.getDecreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    double startRetentionTime = peakModel.getStartRetentionTime();
                    double x = p1.getX() < startRetentionTime ? startRetentionTime : p1.getX();
                    xSeries[0] = p1.getX();
                    ySeries[0] = includeBackground ? p1.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p1.getY();
                    double stopRetentionTime = peakModel.getStopRetentionTime();
                    x = p2.getX() > stopRetentionTime ? stopRetentionTime : p2.getX();
                    xSeries[1] = p2.getX();
                    ySeries[1] = includeBackground ? p2.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p2.getY();
                }
                catch (SolverException solverException) {}
            }
            String id = "Peak Width at " + height * 100.0f + "%";
            series = new Series(xSeries, ySeries, id);
        }
        return series;
    }
}

