/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.components.peak;

import org.eclipse.chemclipse.csd.swt.ui.components.AbstractPeakLineSeriesUI;
import org.eclipse.chemclipse.csd.swt.ui.converter.SeriesConverterCSD;
import org.eclipse.chemclipse.swt.ui.components.peaks.IIncludeBackground;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public abstract class AbstractViewPeakUI
extends AbstractPeakLineSeriesUI
implements IIncludeBackground {
    private boolean includeBackground = false;

    public AbstractViewPeakUI(Composite parent, int style) {
        super(parent, style);
    }

    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    public void setIncludeBackground(boolean includeBackground) {
        this.includeBackground = includeBackground;
    }

    public void setViewSeries() {
        Sign sign = Sign.POSITIVE;
        ISeries series = SeriesConverterCSD.convertPeak(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.RED);
        series = SeriesConverterCSD.convertIncreasingInflectionPoints(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.BLACK);
        series = SeriesConverterCSD.convertDecreasingInflectionPoints(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.BLACK);
        series = SeriesConverterCSD.convertPeakPerpendicular(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        series = SeriesConverterCSD.convertPeakWidthByInflectionPoints(this.peak, this.includeBackground, 0.5f, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        series = SeriesConverterCSD.convertPeakWidthByInflectionPoints(this.peak, this.includeBackground, 0.0f, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        if (this.includeBackground) {
            series = SeriesConverterCSD.convertPeakBackground(this.peak, sign);
            this.addSeries(series);
            lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.BLACK);
        }
    }
}

