/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import java.util.Arrays;
import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;

public abstract class LinearSolverLuBase_CD64
extends LinearSolverAbstract_CD64 {
    protected LUDecompositionBase_CD64 decomp;

    public LinearSolverLuBase_CD64(LUDecompositionBase_CD64 decomp) {
        this.decomp = decomp;
    }

    @Override
    public boolean setA(CDenseMatrix64F A) {
        this._setA(A);
        return this.decomp.decompose(A);
    }

    @Override
    public double quality() {
        return this.decomp.quality();
    }

    @Override
    public void invert(CDenseMatrix64F A_inv) {
        double[] vv = this.decomp._getVV();
        CDenseMatrix64F LU = this.decomp.getLU();
        if (A_inv.numCols != LU.numCols || A_inv.numRows != LU.numRows) {
            throw new IllegalArgumentException("Unexpected matrix dimension");
        }
        int n = this.A.numCols;
        double[] dataInv = A_inv.data;
        int strideAinv = A_inv.getRowStride();
        int j = 0;
        while (j < n) {
            Arrays.fill(vv, 0, n * 2, 0.0);
            vv[j * 2] = 1.0;
            vv[j * 2 + 1] = 0.0;
            this.decomp._solveVectorInternal(vv);
            int index = j * 2;
            int i = 0;
            while (i < n) {
                dataInv[index] = vv[i * 2];
                dataInv[index + 1] = vv[i * 2 + 1];
                ++i;
                index += strideAinv;
            }
            ++j;
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public LUDecompositionBase_CD64 getDecomposition() {
        return this.decomp;
    }
}

