/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.ext.internal.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.swtchart.ILegend;
import org.swtchart.ext.InteractiveChart;
import org.swtchart.ext.internal.properties.AbstractPage;
import org.swtchart.ext.internal.properties.PropertiesResources;

public class LegendPage
extends AbstractPage {
    private static final String LEGEND_FONT = "org.swtchart.legend.font";
    private static final String LEGEND_FOREGROUND = "org.swtchart.legend.foreground";
    private static final String LEGEND_GACKGROUND = "org.swtchart.legend.background";
    protected Button showLegendButton;
    private Label backgroundLabel;
    private ColorSelector backgroundButton;
    private Label foregroundLabel;
    private ColorSelector foregroundButton;
    private Label fontSizeLabel;
    private Spinner fontSizeSpinner;
    private ILegend legend;

    public LegendPage(InteractiveChart chart, PropertiesResources resources, String title) {
        super(chart, resources, title);
        this.legend = chart.getLegend();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.addLegendPanel(composite);
        this.selectValues();
        return composite;
    }

    private void addLegendPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        this.showLegendButton = this.createCheckBoxControl(group, "Show legend");
        this.showLegendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = LegendPage.this.showLegendButton.getSelection();
                LegendPage.this.setControlsEnable(visible);
            }
        });
        this.backgroundLabel = this.createLabelControl(group, "Background:");
        this.backgroundButton = this.createColorButtonControl(group);
        this.foregroundLabel = this.createLabelControl(group, "Foreground:");
        this.foregroundButton = this.createColorButtonControl(group);
        this.fontSizeLabel = this.createLabelControl(group, "Font size:");
        this.fontSizeSpinner = this.createSpinnerControl(group, 8, 30);
    }

    private void selectValues() {
        this.showLegendButton.setSelection(this.legend.isVisible());
        this.setControlsEnable(this.legend.isVisible());
        this.backgroundButton.setColorValue(this.legend.getBackground().getRGB());
        this.foregroundButton.setColorValue(this.legend.getForeground().getRGB());
        this.fontSizeSpinner.setSelection(this.legend.getFont().getFontData()[0].getHeight());
    }

    protected void setControlsEnable(boolean enabled) {
        this.backgroundLabel.setEnabled(enabled);
        this.backgroundButton.setEnabled(enabled);
        this.foregroundLabel.setEnabled(enabled);
        this.foregroundButton.setEnabled(enabled);
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
    }

    @Override
    public void apply() {
        this.legend.setVisible(this.showLegendButton.getSelection());
        Color color = new Color((Device)Display.getDefault(), this.backgroundButton.getColorValue());
        this.legend.setBackground(color);
        this.resources.put(LEGEND_GACKGROUND, color);
        color = new Color((Device)Display.getDefault(), this.foregroundButton.getColorValue());
        this.legend.setForeground(color);
        this.resources.put(LEGEND_FOREGROUND, color);
        FontData fontData = this.legend.getFont().getFontData()[0];
        Font font = new Font(this.legend.getFont().getDevice(), fontData.getName(), this.fontSizeSpinner.getSelection(), fontData.getStyle());
        this.legend.setFont(font);
        this.resources.put(LEGEND_FONT, font);
    }

    protected void performDefaults() {
        this.showLegendButton.setSelection(true);
        this.setControlsEnable(true);
        this.backgroundButton.setColorValue(new RGB(255, 255, 255));
        this.foregroundButton.setColorValue(new RGB(0, 0, 0));
        this.fontSizeSpinner.setSelection(9);
        super.performDefaults();
    }
}

