/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.peak.detector.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlope;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlopes;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class DetectorSlopes
implements IDetectorSlopes {
    private List<IDetectorSlope> slopes;
    private int startScan;
    private int stopScan;

    public DetectorSlopes(ITotalScanSignals totalIonSignals) {
        this.startScan = totalIonSignals.getStartScan();
        this.stopScan = totalIonSignals.getStopScan() - 1;
        int amount = this.stopScan - this.startScan + 1;
        this.slopes = new ArrayList<IDetectorSlope>(amount);
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public void add(IDetectorSlope detectorSlope) {
        this.slopes.add(detectorSlope);
    }

    @Override
    public void calculateMovingAverage(WindowSize windowSize) {
        if (windowSize == null) {
            return;
        }
        if (this.slopes.size() < windowSize.getSize()) {
            return;
        }
        int diff = windowSize.getSize() / 2;
        int windowStop = windowSize.getSize() - diff;
        int size = this.slopes.size() - diff;
        double[] values = new double[windowSize.getSize()];
        int i = diff;
        while (i < size) {
            int j = -diff;
            int k = 0;
            while (j < windowStop) {
                values[k] = this.slopes.get(i + j).getSlope();
                ++j;
                ++k;
            }
            this.slopes.get(i).setSlope(Calculations.getMean((double[])values));
            ++i;
        }
    }

    @Override
    public IDetectorSlope getDetectorSlope(int scan) {
        if (scan >= this.startScan && scan <= this.stopScan) {
            return this.slopes.get(scan -= this.startScan);
        }
        return null;
    }

    @Override
    public int size() {
        return this.slopes.size();
    }
}

