/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.signals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.ChromatogramSelection;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignalComparator;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class TotalScanSignals
implements ITotalScanSignals {
    private List<ITotalScanSignal> signals;
    private int startScan;
    private int stopScan;
    private IChromatogram chromatogram = null;

    public TotalScanSignals(int numberOfScans) {
        if (numberOfScans <= 0) {
            numberOfScans = 0;
            this.startScan = 0;
            this.stopScan = 0;
        } else {
            this.startScan = 1;
            this.stopScan = numberOfScans;
        }
        this.signals = new ArrayList<ITotalScanSignal>(numberOfScans);
    }

    public TotalScanSignals(int numberOfScans, IChromatogram chromatogram) {
        this(numberOfScans);
        this.chromatogram = chromatogram;
    }

    public TotalScanSignals(int startScan, int stopScan) {
        int numberOfScans;
        startScan = startScan <= 0 ? 0 : startScan;
        stopScan = stopScan <= 0 ? 0 : stopScan;
        int start = Math.min(startScan, stopScan);
        int stop = Math.max(startScan, stopScan);
        if (start == 0 || stop == 0) {
            numberOfScans = 0;
            start = 0;
            stop = 0;
        } else {
            numberOfScans = stop - start + 1;
        }
        this.signals = new ArrayList<ITotalScanSignal>(numberOfScans);
        this.startScan = start;
        this.stopScan = stop;
    }

    public TotalScanSignals(int startScan, int stopScan, IChromatogram chromatogram) {
        this(startScan, stopScan);
        this.chromatogram = chromatogram;
    }

    public TotalScanSignals(IChromatogram chromatogram) throws ChromatogramIsNullException {
        this(new ChromatogramSelection(chromatogram));
    }

    public TotalScanSignals(IChromatogramSelection chromatogramSelection) {
        this.chromatogram = chromatogramSelection.getChromatogram();
        this.startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        this.stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        this.signals = new ArrayList<ITotalScanSignal>();
        int scan = this.startScan;
        while (scan <= this.stopScan) {
            IScan supplierScan = this.chromatogram.getScan(scan);
            int retentionTime = supplierScan.getRetentionTime();
            float retentionIndex = supplierScan.getRetentionIndex();
            float totalSignal = supplierScan.getTotalSignal();
            this.signals.add(new TotalScanSignal(retentionTime, retentionIndex, totalSignal));
            ++scan;
        }
    }

    @Override
    public IChromatogram getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public void add(ITotalScanSignal totalScanSignal) {
        this.signals.add(totalScanSignal);
    }

    @Override
    public ITotalScanSignal getTotalScanSignal(int scan) {
        if (scan <= 0) {
            return null;
        }
        if (scan < this.startScan || scan > this.stopScan) {
            return null;
        }
        int correction = this.startScan - 1;
        scan -= correction;
        return this.signals.get(--scan);
    }

    @Override
    public ITotalScanSignal getNextTotalScanSignal(int scan) {
        ITotalScanSignal signal = this.getTotalScanSignal(++scan);
        return signal;
    }

    @Override
    public ITotalScanSignal getPreviousTotalScanSignal(int scan) {
        ITotalScanSignal signal = this.getTotalScanSignal(--scan);
        return signal;
    }

    @Override
    public int size() {
        return this.signals.size();
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public float getMaxSignal() {
        if (this.size() == 0) {
            return 0.0f;
        }
        float[] values = this.getValues();
        float max = Calculations.getMax((float[])values);
        return max;
    }

    @Override
    public float getMinSignal() {
        if (this.size() == 0) {
            return 0.0f;
        }
        float[] values = this.getValues();
        float min = Calculations.getMin((float[])values);
        return min;
    }

    @Override
    public ITotalScanSignals makeDeepCopy() {
        TotalScanSignals totalIonSignals = new TotalScanSignals(this.getStartScan(), this.getStopScan());
        for (ITotalScanSignal signal : this.signals) {
            ITotalScanSignal totalIonSignal = signal.makeDeepCopy();
            totalIonSignals.add(totalIonSignal);
        }
        return totalIonSignals;
    }

    @Override
    public List<ITotalScanSignal> getTotalScanSignals() {
        return new ArrayList<ITotalScanSignal>(this.signals);
    }

    @Override
    public ITotalScanSignal getMaxTotalScanSignal() {
        return Collections.max(this.signals, new TotalScanSignalComparator());
    }

    @Override
    public ITotalScanSignal getMinTotalScanSignal() {
        return Collections.min(this.signals, new TotalScanSignalComparator());
    }

    @Override
    public void setNegativeTotalSignalsToZero() {
        for (ITotalScanSignal signal : this.signals) {
            if (!(signal.getTotalSignal() < 0.0f)) continue;
            signal.setTotalSignal(0.0f);
        }
    }

    @Override
    public void setPositiveTotalSignalsToZero() {
        for (ITotalScanSignal signal : this.signals) {
            if (!(signal.getTotalSignal() > 0.0f)) continue;
            signal.setTotalSignal(0.0f);
        }
    }

    @Override
    public void setTotalSignalsAsAbsoluteValues() {
        float abundance = 0.0f;
        for (ITotalScanSignal signal : this.signals) {
            abundance = Math.abs(signal.getTotalSignal());
            signal.setTotalSignal(abundance);
        }
    }

    private float[] getValues() {
        float[] values = new float[this.size()];
        int i = 0;
        for (ITotalScanSignal signal : this.signals) {
            values[i++] = signal.getTotalSignal();
        }
        return values;
    }
}

