/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.wizards;

import org.eclipse.chemclipse.support.l10n.Messages;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.support.ui.wizards.IWizardElements;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectFileWizardPage
extends AbstractExtendedWizardPage {
    private IWizardElements wizardElements;
    private String defaultReportName;
    private String reportExtension;
    private Label labelProjectName;
    private Text reportNameText;

    public SelectFileWizardPage(IWizardElements wizardElements, String defaultReportName, String reportExtension) {
        super("SelectFileWizardPage");
        this.setTitle(SupportMessages.INSTANCE().getMessage("labelFileName", new String[0]));
        this.setDescription(SupportMessages.INSTANCE().getMessage("labelFileNameInfo", new String[0]));
        this.wizardElements = wizardElements;
        this.defaultReportName = defaultReportName;
        this.reportExtension = reportExtension;
    }

    @Override
    public boolean canFinish() {
        String fileName = this.wizardElements.getFileName();
        return fileName != null && !fileName.equals("");
    }

    @Override
    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setSelectedProjectName();
            this.validateReportName();
        }
    }

    public void createControl(Composite parent) {
        Messages messages = SupportMessages.INSTANCE();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        Label labelProject = new Label(composite, 0);
        labelProject.setText(messages.getMessage("labelFileCreationProjectPath", new String[0]));
        labelProject.setLayoutData((Object)gridData);
        this.labelProjectName = new Label(composite, 64);
        this.setSelectedProjectName();
        this.labelProjectName.setForeground(Display.getCurrent().getSystemColor(16));
        this.labelProjectName.setLayoutData((Object)gridData);
        Label labelReport = new Label(composite, 0);
        labelReport.setText(messages.getMessage("labelSelectFileName", new String[0]));
        labelReport.setLayoutData((Object)gridData);
        this.reportNameText = new Text(composite, 2048);
        this.reportNameText.setText(this.defaultReportName);
        this.reportNameText.setLayoutData((Object)new GridData(768));
        this.reportNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectFileWizardPage.this.validateReportName();
            }
        });
        this.validateReportName();
        this.setControl((Control)composite);
    }

    private void setSelectedProjectName() {
        if (this.wizardElements.getContainer() != null) {
            this.labelProjectName.setText(this.wizardElements.getContainer().getFullPath().toString());
        } else {
            this.labelProjectName.setText(SupportMessages.INSTANCE().getMessage("labelSelectProject", new String[0]));
        }
    }

    private void validateReportName() {
        Messages messages = SupportMessages.INSTANCE();
        String message = null;
        String fileName = this.reportNameText.getText().trim();
        if (fileName == null || fileName.equals("")) {
            message = messages.getMessage("processingSelectFileName", new String[0]);
        } else {
            IContainer container;
            if (!fileName.endsWith(this.reportExtension)) {
                fileName = String.valueOf(fileName) + this.reportExtension;
            }
            if ((container = this.wizardElements.getContainer()) != null) {
                if (container.exists()) {
                    if (container instanceof IFolder) {
                        IFolder folder = (IFolder)container;
                        IFile file = folder.getFile(fileName);
                        if (file.exists()) {
                            message = messages.getMessage("processingFileExists", new String[0]);
                        } else {
                            this.wizardElements.setFileName(fileName);
                        }
                    } else if (container instanceof IProject) {
                        IProject project = (IProject)container;
                        if (project.exists()) {
                            IFile file = project.getFile(fileName);
                            if (file.exists()) {
                                message = messages.getMessage("processingFileExists", new String[0]);
                            } else {
                                this.wizardElements.setFileName(fileName);
                            }
                        } else {
                            this.wizardElements.setFileName(fileName);
                        }
                    } else {
                        message = messages.getMessage("processingSelectValidFolderFile", new String[0]);
                    }
                } else {
                    this.wizardElements.setFileName(fileName);
                }
            } else {
                message = messages.getMessage("processingSelectValidFolderFile", new String[0]);
            }
        }
        this.updateStatus(message);
    }
}

