/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.msd.model.core.IIon;

public class IonValueComparator
implements Comparator<IIon>,
Serializable {
    private static final long serialVersionUID = 1727218244178920202L;
    private SortOrder sortOrder;

    public IonValueComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public IonValueComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IIon ion1, IIon ion2) {
        int returnValue;
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Double.compare(ion1.getIon(), ion2.getIon());
                break;
            }
            case DESC: {
                returnValue = Double.compare(ion2.getIon(), ion1.getIon());
                break;
            }
            default: {
                returnValue = Double.compare(ion1.getIon(), ion2.getIon());
            }
        }
        return returnValue;
    }
}

